/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.CoreMetadataFactory;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.GenericParameter;
import com.strobel.assembler.metadata.GenericParameterCollection;
import com.strobel.assembler.metadata.IClassSignature;
import com.strobel.assembler.metadata.IGenericContext;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.IMethodSignature;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.signatures.ClassSignature;
import com.strobel.assembler.metadata.signatures.ClassTypeSignature;
import com.strobel.assembler.metadata.signatures.FieldTypeSignature;
import com.strobel.assembler.metadata.signatures.FormalTypeParameter;
import com.strobel.assembler.metadata.signatures.MethodTypeSignature;
import com.strobel.assembler.metadata.signatures.Reifier;
import com.strobel.assembler.metadata.signatures.ReturnType;
import com.strobel.assembler.metadata.signatures.SignatureParser;
import com.strobel.assembler.metadata.signatures.TypeSignature;
import com.strobel.compilerservices.RuntimeHelpers;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.SafeCloseable;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.util.EmptyArrayCache;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;

public final class MetadataParser {
    private final IMetadataResolver _resolver;
    private final SignatureParser _signatureParser;
    private final Stack<IGenericContext> _genericContexts;
    private final CoreMetadataFactory _factory;
    private final AtomicInteger _suppressResolveDepth;
    private static final TypeReference[] PRIMITIVE_TYPES;

    public MetadataParser() {
        this(MetadataSystem.instance());
    }

    public MetadataParser(IMetadataResolver resolver) {
        this._resolver = (IMetadataResolver)VerifyArgument.notNull((Object)resolver, (String)"resolver");
        this._signatureParser = SignatureParser.make();
        this._genericContexts = new Stack();
        this._factory = CoreMetadataFactory.make(resolver, (IGenericContext)new StackBasedGenericContext());
        this._suppressResolveDepth = new AtomicInteger();
    }

    public MetadataParser(TypeDefinition owner) {
        VerifyArgument.notNull((Object)owner, (String)"owner");
        this._resolver = owner.getResolver() != null ? owner.getResolver() : MetadataSystem.instance();
        this._signatureParser = SignatureParser.make();
        this._genericContexts = new Stack();
        this._factory = CoreMetadataFactory.make(owner, (IGenericContext)new StackBasedGenericContext());
        this._suppressResolveDepth = new AtomicInteger();
    }

    public final SafeCloseable suppressTypeResolution() {
        this._suppressResolveDepth.incrementAndGet();
        return new SafeCloseable(){

            public void close() {
                MetadataParser.this._suppressResolveDepth.decrementAndGet();
            }
        };
    }

    public final IMetadataResolver getResolver() {
        return this._resolver;
    }

    public void pushGenericContext(IGenericContext context) {
        this._genericContexts.push((IGenericContext)VerifyArgument.notNull((Object)context, (String)"context"));
    }

    public void popGenericContext() {
        this._genericContexts.pop();
    }

    public TypeReference parseTypeDescriptor(String descriptor) {
        VerifyArgument.notNull((Object)descriptor, (String)"descriptor");
        if (descriptor.startsWith("[")) {
            return this.parseTypeSignature(descriptor);
        }
        return this.parseTypeSignature("L" + descriptor + ";");
    }

    public TypeReference parseTypeSignature(String signature) {
        VerifyArgument.notNull((Object)signature, (String)"signature");
        TypeSignature typeSignature = this._signatureParser.parseTypeSignature(signature);
        Reifier reifier = Reifier.make(this._factory);
        typeSignature.accept(reifier);
        return reifier.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldReference parseField(TypeReference declaringType, String name, String signature) {
        VerifyArgument.notNull((Object)declaringType, (String)"declaringType");
        VerifyArgument.notNull((Object)name, (String)"name");
        VerifyArgument.notNull((Object)signature, (String)"signature");
        this.pushGenericContext(declaringType);
        try {
            UnresolvedField unresolvedField = new UnresolvedField(declaringType, name, this.parseTypeSignature(signature));
            return unresolvedField;
        }
        finally {
            this.popGenericContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodReference parseMethod(TypeReference declaringType, String name, String descriptor) {
        VerifyArgument.notNull((Object)declaringType, (String)"declaringType");
        VerifyArgument.notNull((Object)name, (String)"name");
        VerifyArgument.notNull((Object)descriptor, (String)"descriptor");
        this.pushGenericContext(declaringType);
        try {
            IMethodSignature signature = this.parseMethodSignature(descriptor);
            MethodReference methodReference = this.lookupMethod(declaringType, name, signature);
            return methodReference;
        }
        finally {
            this.popGenericContext();
        }
    }

    public TypeReference lookupType(String packageName, String typeName) {
        String dottedName = StringUtilities.isNullOrEmpty((String)packageName) ? typeName : packageName + "." + typeName;
        TypeReference reference = this._factory.makeNamedType(dottedName);
        if (this._suppressResolveDepth.get() > 0) {
            return reference;
        }
        return reference;
    }

    protected TypeReference lookupTypeVariable(String name) {
        int n = this._genericContexts.size();
        for (int i = 0; i < n; ++i) {
            IGenericContext context = (IGenericContext)this._genericContexts.get(i);
            GenericParameter typeVariable = context.findTypeVariable(name);
            if (typeVariable == null) continue;
            return typeVariable;
        }
        if (this._resolver instanceof IGenericContext) {
            return ((IGenericContext)((Object)this._resolver)).findTypeVariable(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMethodSignature parseMethodSignature(String signature) {
        VerifyArgument.notNull((Object)signature, (String)"signature");
        MethodTypeSignature methodTypeSignature = this._signatureParser.parseMethodSignature(signature);
        Reifier reifier = Reifier.make(this._factory);
        ReturnType returnTypeSignature = methodTypeSignature.getReturnType();
        Object[] parameterTypeSignatures = methodTypeSignature.getParameterTypes();
        Object[] genericParameterSignatures = methodTypeSignature.getFormalTypeParameters();
        Object[] thrownTypeSignatures = methodTypeSignature.getExceptionTypes();
        boolean needPopGenericContext = false;
        try {
            List thrownTypes;
            List parameterTypes;
            int i;
            List genericParameters;
            if (ArrayUtilities.isNullOrEmpty((Object[])genericParameterSignatures)) {
                genericParameters = Collections.emptyList();
            } else {
                Object[] gp = new GenericParameter[genericParameterSignatures.length];
                this.pushGenericContext(new IGenericContext((GenericParameter[])gp){
                    final /* synthetic */ GenericParameter[] val$gp;
                    {
                        this.val$gp = genericParameterArray;
                    }

                    @Override
                    public GenericParameter findTypeVariable(String name) {
                        for (GenericParameter g : this.val$gp) {
                            if (g == null) break;
                            if (!StringUtilities.equals((String)g.getName(), (String)name)) continue;
                            return g;
                        }
                        return null;
                    }
                });
                needPopGenericContext = true;
                for (i = 0; i < gp.length; ++i) {
                    gp[i] = this._factory.makeTypeVariable(((FormalTypeParameter)genericParameterSignatures[i]).getName(), (FieldTypeSignature[])EmptyArrayCache.fromElementType(FieldTypeSignature.class));
                }
                genericParameters = ArrayUtilities.asUnmodifiableList((Object[])gp);
                for (i = 0; i < gp.length; ++i) {
                    Object[] bounds = ((FormalTypeParameter)genericParameterSignatures[i]).getBounds();
                    if (ArrayUtilities.isNullOrEmpty((Object[])bounds)) continue;
                    ((GenericParameter)gp[i]).setExtendsBound(this._factory.makeTypeBound((FieldTypeSignature[])bounds));
                }
            }
            returnTypeSignature.accept(reifier);
            TypeReference returnType = reifier.getResult();
            if (ArrayUtilities.isNullOrEmpty((Object[])parameterTypeSignatures)) {
                parameterTypes = Collections.emptyList();
            } else {
                Object[] pt = new TypeReference[parameterTypeSignatures.length];
                for (i = 0; i < pt.length; ++i) {
                    parameterTypeSignatures[i].accept(reifier);
                    pt[i] = reifier.getResult();
                }
                parameterTypes = ArrayUtilities.asUnmodifiableList((Object[])pt);
            }
            if (ArrayUtilities.isNullOrEmpty((Object[])thrownTypeSignatures)) {
                thrownTypes = Collections.emptyList();
            } else {
                Object[] tt = new TypeReference[thrownTypeSignatures.length];
                for (i = 0; i < tt.length; ++i) {
                    thrownTypeSignatures[i].accept(reifier);
                    tt[i] = reifier.getResult();
                }
                thrownTypes = ArrayUtilities.asUnmodifiableList((Object[])tt);
            }
            IMethodSignature iMethodSignature = this._factory.makeMethodSignature(returnType, parameterTypes, genericParameters, thrownTypes);
            return iMethodSignature;
        }
        finally {
            if (needPopGenericContext) {
                this.popGenericContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IClassSignature parseClassSignature(String signature) {
        VerifyArgument.notNull((Object)signature, (String)"signature");
        ClassSignature classSignature = this._signatureParser.parseClassSignature(signature);
        Reifier reifier = Reifier.make(this._factory);
        ClassTypeSignature baseTypeSignature = classSignature.getSuperType();
        Object[] interfaceTypeSignatures = classSignature.getInterfaces();
        Object[] genericParameterSignatures = classSignature.getFormalTypeParameters();
        boolean needPopGenericContext = false;
        try {
            List interfaceTypes;
            int i;
            List genericParameters;
            if (ArrayUtilities.isNullOrEmpty((Object[])genericParameterSignatures)) {
                genericParameters = Collections.emptyList();
            } else {
                Object[] gp = new GenericParameter[genericParameterSignatures.length];
                this.pushGenericContext(new IGenericContext((GenericParameter[])gp){
                    final /* synthetic */ GenericParameter[] val$gp;
                    {
                        this.val$gp = genericParameterArray;
                    }

                    @Override
                    public GenericParameter findTypeVariable(String name) {
                        for (GenericParameter g : this.val$gp) {
                            if (g == null) break;
                            if (!StringUtilities.equals((String)g.getName(), (String)name)) continue;
                            return g;
                        }
                        return null;
                    }
                });
                needPopGenericContext = true;
                for (i = 0; i < gp.length; ++i) {
                    gp[i] = this._factory.makeTypeVariable(((FormalTypeParameter)genericParameterSignatures[i]).getName(), (FieldTypeSignature[])EmptyArrayCache.fromElementType(FieldTypeSignature.class));
                }
                genericParameters = ArrayUtilities.asUnmodifiableList((Object[])gp);
                for (i = 0; i < gp.length; ++i) {
                    Object[] bounds = ((FormalTypeParameter)genericParameterSignatures[i]).getBounds();
                    if (ArrayUtilities.isNullOrEmpty((Object[])bounds)) continue;
                    ((GenericParameter)gp[i]).setExtendsBound(this._factory.makeTypeBound((FieldTypeSignature[])bounds));
                }
            }
            baseTypeSignature.accept(reifier);
            TypeReference baseType = reifier.getResult();
            if (ArrayUtilities.isNullOrEmpty((Object[])interfaceTypeSignatures)) {
                interfaceTypes = Collections.emptyList();
            } else {
                Object[] it = new TypeReference[interfaceTypeSignatures.length];
                for (i = 0; i < it.length; ++i) {
                    ((ClassTypeSignature)interfaceTypeSignatures[i]).accept(reifier);
                    it[i] = reifier.getResult();
                }
                interfaceTypes = ArrayUtilities.asUnmodifiableList((Object[])it);
            }
            IClassSignature iClassSignature = this._factory.makeClassSignature(baseType, interfaceTypes, genericParameters);
            return iClassSignature;
        }
        finally {
            if (needPopGenericContext) {
                this.popGenericContext();
            }
        }
    }

    protected MethodReference lookupMethod(TypeReference declaringType, String name, IMethodSignature signature) {
        UnresolvedMethod reference = new UnresolvedMethod(declaringType, name, signature);
        if (this._suppressResolveDepth.get() > 0) {
            return reference;
        }
        return reference;
    }

    private static int hashPrimitiveName(String name) {
        if (name.length() < 3) {
            return 0;
        }
        return (name.charAt(0) + name.charAt(2)) % 16;
    }

    static {
        TypeReference[] allPrimitives;
        PRIMITIVE_TYPES = new TypeReference[16];
        RuntimeHelpers.ensureClassInitialized(MetadataSystem.class);
        TypeReference[] arr$ = allPrimitives = new TypeReference[]{BuiltinTypes.Boolean, BuiltinTypes.Byte, BuiltinTypes.Character, BuiltinTypes.Short, BuiltinTypes.Integer, BuiltinTypes.Long, BuiltinTypes.Float, BuiltinTypes.Double, BuiltinTypes.Void};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            TypeReference t;
            MetadataParser.PRIMITIVE_TYPES[MetadataParser.hashPrimitiveName((String)t.getName())] = t = arr$[i$];
        }
    }

    private final class UnresolvedField
    extends FieldReference {
        private final TypeReference _declaringType;
        private final String _name;
        private final TypeReference _fieldType;

        UnresolvedField(TypeReference declaringType, String name, TypeReference fieldType) {
            this._declaringType = (TypeReference)VerifyArgument.notNull((Object)declaringType, (String)"declaringType");
            this._name = (String)VerifyArgument.notNull((Object)name, (String)"name");
            this._fieldType = (TypeReference)VerifyArgument.notNull((Object)fieldType, (String)"fieldType");
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public TypeReference getDeclaringType() {
            return this._declaringType;
        }

        @Override
        public TypeReference getFieldType() {
            return this._fieldType;
        }

        @Override
        protected StringBuilder appendName(StringBuilder sb, boolean fullName, boolean dottedName) {
            TypeReference declaringType;
            if (fullName && (declaringType = this.getDeclaringType()) != null) {
                return declaringType.appendName(sb, true, false).append('.').append(this._name);
            }
            return sb.append(this._name);
        }
    }

    private final class UnresolvedMethod
    extends MethodReference {
        private final TypeReference _declaringType;
        private final String _name;
        private final IMethodSignature _signature;
        private final List<GenericParameter> _genericParameters;

        UnresolvedMethod(TypeReference declaringType, String name, IMethodSignature signature) {
            this._declaringType = (TypeReference)VerifyArgument.notNull((Object)declaringType, (String)"declaringType");
            this._name = (String)VerifyArgument.notNull((Object)name, (String)"name");
            this._signature = (IMethodSignature)VerifyArgument.notNull((Object)signature, (String)"signature");
            if (this._signature.hasGenericParameters()) {
                GenericParameterCollection genericParameters = new GenericParameterCollection(this);
                for (GenericParameter genericParameter : this._signature.getGenericParameters()) {
                    genericParameters.add(genericParameter);
                }
                genericParameters.freeze(false);
                this._genericParameters = genericParameters;
            } else {
                this._genericParameters = Collections.emptyList();
            }
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public TypeReference getReturnType() {
            return this._signature.getReturnType();
        }

        @Override
        public List<ParameterDefinition> getParameters() {
            return this._signature.getParameters();
        }

        @Override
        public TypeReference getDeclaringType() {
            return this._declaringType;
        }

        @Override
        public List<GenericParameter> getGenericParameters() {
            return this._genericParameters;
        }

        @Override
        public List<TypeReference> getThrownTypes() {
            return this._signature.getThrownTypes();
        }
    }

    private final class StackBasedGenericContext
    implements IGenericContext {
        private StackBasedGenericContext() {
        }

        @Override
        public GenericParameter findTypeVariable(String name) {
            for (int i = MetadataParser.this._genericContexts.size() - 1; i >= 0; --i) {
                IGenericContext context = (IGenericContext)MetadataParser.this._genericContexts.get(i);
                GenericParameter typeVariable = context.findTypeVariable(name);
                if (typeVariable == null) continue;
                return typeVariable;
            }
            if (MetadataParser.this._resolver instanceof IGenericContext) {
                return ((IGenericContext)((Object)MetadataParser.this._resolver)).findTypeVariable(name);
            }
            return null;
        }
    }
}

