/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.TextLocation;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class Identifier
extends AstNode {
    private TextLocation _startLocation;
    private String _name;
    public static final Identifier NULL = new NullIdentifier();

    private Identifier() {
        this("", TextLocation.EMPTY);
    }

    protected Identifier(String name, TextLocation location) {
        this._name = (String)VerifyArgument.notNull((Object)name, (String)"name");
        this._startLocation = (TextLocation)VerifyArgument.notNull((Object)location, (String)"location");
    }

    public final String getName() {
        return this._name;
    }

    public final void setName(String name) {
        this.verifyNotFrozen();
        this._name = (String)VerifyArgument.notNull((Object)name, (String)"name");
    }

    @Override
    public TextLocation getStartLocation() {
        return this._startLocation;
    }

    public void setStartLocation(TextLocation startLocation) {
        this._startLocation = startLocation;
    }

    @Override
    public TextLocation getEndLocation() {
        String name = this._name;
        return new TextLocation(this._startLocation.line(), this._startLocation.column() + (name != null ? name.length() : 0));
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitIdentifier(this, data);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.TOKEN;
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof Identifier && !other.isNull() && Identifier.matchString(this.getName(), ((Identifier)other).getName());
    }

    public static Identifier create(String name) {
        return Identifier.create(name, TextLocation.EMPTY);
    }

    public static Identifier create(String name, TextLocation location) {
        if (StringUtilities.isNullOrEmpty((String)name)) {
            return NULL;
        }
        return new Identifier(name, location);
    }

    private static final class NullIdentifier
    extends Identifier {
        private NullIdentifier() {
        }

        @Override
        public final boolean isNull() {
            return true;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return null;
        }

        @Override
        public boolean matches(INode other, Match match) {
            return other == null || other.isNull();
        }
    }
}

