/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.patterns;

import com.strobel.decompiler.patterns.BacktrackingInfo;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;
import com.strobel.functions.Function;
import com.strobel.util.ContractUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

public interface INode {
    public static final Function<INode, Iterable<INode>> CHILD_ITERATOR = new Function<INode, Iterable<INode>>(){

        public Iterable<INode> apply(final INode input) {
            return new Iterable<INode>(){

                @Override
                public final Iterator<INode> iterator() {
                    return new Iterator<INode>(){
                        INode next;
                        {
                            this.next = input.getFirstChild();
                        }

                        @Override
                        public final boolean hasNext() {
                            return this.next != null;
                        }

                        @Override
                        public final INode next() {
                            INode result = this.next;
                            if (result == null) {
                                throw new NoSuchElementException();
                            }
                            this.next = result.getNextSibling();
                            return result;
                        }

                        @Override
                        public final void remove() {
                            throw ContractUtils.unsupported();
                        }
                    };
                }
            };
        }
    };

    public boolean isNull();

    public Role getRole();

    public INode getFirstChild();

    public INode getNextSibling();

    public boolean matches(INode var1, Match var2);

    public boolean matchesCollection(Role var1, INode var2, Match var3, BacktrackingInfo var4);

    public Match match(INode var1);

    public boolean matches(INode var1);
}

