/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.FileCacheFilter;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.filecache.FileCache;
import org.glassfish.grizzly.http.server.io.NIOOutputStream;
import org.glassfish.grizzly.http.server.io.OutputBuffer;
import org.glassfish.grizzly.http.server.util.MimeType;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.ArraySet;

public class StaticHttpHandler
extends HttpHandler {
    private static final Logger LOGGER = Grizzly.logger(StaticHttpHandler.class);
    protected final ArraySet<File> docRoots = new ArraySet(File.class);
    private volatile int fileCacheFilterIdx = -1;
    private volatile boolean isFileCacheEnabled = true;

    public StaticHttpHandler() {
        this.addDocRoot(".");
    }

    public StaticHttpHandler(String ... docRoots) {
        if (docRoots != null) {
            for (String docRoot : docRoots) {
                this.addDocRoot(docRoot);
            }
        }
    }

    public StaticHttpHandler(Set<String> docRoots) {
        if (docRoots != null) {
            for (String docRoot : docRoots) {
                this.addDocRoot(docRoot);
            }
        }
    }

    public File getDefaultDocRoot() {
        File[] array = (File[])this.docRoots.getArray();
        return array != null && array.length > 0 ? array[0] : null;
    }

    public ArraySet<File> getDocRoots() {
        return this.docRoots;
    }

    public final File addDocRoot(String docRoot) {
        if (docRoot == null) {
            throw new NullPointerException("docRoot can't be null");
        }
        File file = new File(docRoot);
        this.addDocRoot(file);
        return file;
    }

    public final void addDocRoot(File docRoot) {
        this.docRoots.add((Object)docRoot);
    }

    public void removeDocRoot(File docRoot) {
        this.docRoots.remove((Object)docRoot);
    }

    public boolean isFileCacheEnabled() {
        return this.isFileCacheEnabled;
    }

    public void setFileCacheEnabled(boolean isFileCacheEnabled) {
        this.isFileCacheEnabled = isFileCacheEnabled;
    }

    public static void sendFile(Response response, File file) throws IOException {
        response.setStatus(HttpStatus.OK_200);
        StaticHttpHandler.pickupContentType(response, file);
        long length = file.length();
        response.setContentLengthLong(length);
        response.addDateHeader(Header.Date, System.currentTimeMillis());
        if (!response.isSendFileEnabled() || response.getRequest().isSecure()) {
            StaticHttpHandler.sendUsingBuffers(response, file);
        } else {
            StaticHttpHandler.sendZeroCopy(response, file);
        }
    }

    private static void sendUsingBuffers(Response response, File file) throws FileNotFoundException, IOException {
        int chunkSize = 8192;
        response.suspend();
        NIOOutputStream outputStream = response.getNIOOutputStream();
        outputStream.notifyCanWrite(new NonBlockingDownloadHandler(response, outputStream, file, 8192), 12288);
    }

    private static void sendZeroCopy(Response response, File file) throws IOException {
        OutputBuffer outputBuffer = response.getOutputBuffer();
        outputBuffer.sendfile(file, null);
    }

    public final boolean addToFileCache(Request req, Response res, File resource) {
        FileCache fileCache;
        FilterChainContext fcContext;
        FileCacheFilter fileCacheFilter;
        if (this.isFileCacheEnabled && (fileCacheFilter = this.lookupFileCache(fcContext = req.getContext())) != null && (fileCache = fileCacheFilter.getFileCache()).isEnabled()) {
            if (res != null) {
                StaticHttpHandler.addCachingHeaders(res, resource);
            }
            fileCache.add(req.getRequest(), resource);
            return true;
        }
        return false;
    }

    @Override
    public void service(Request request, Response response) throws Exception {
        String uri = this.getRelativeURI(request);
        if (uri == null || !this.handle(uri, request, response)) {
            this.onMissingResource(request, response);
        }
    }

    protected String getRelativeURI(Request request) {
        String uri = request.getRequestURI();
        if (uri.contains("..")) {
            return null;
        }
        String resourcesContextPath = request.getContextPath();
        if (resourcesContextPath != null && !resourcesContextPath.isEmpty()) {
            if (!uri.startsWith(resourcesContextPath)) {
                return null;
            }
            uri = uri.substring(resourcesContextPath.length());
        }
        return uri;
    }

    protected void onMissingResource(Request request, Response response) throws Exception {
        response.setStatus(HttpStatus.NOT_FOUND_404);
        this.customizedErrorPage(request, response);
    }

    protected boolean handle(String uri, Request request, Response response) throws Exception {
        boolean found = false;
        File[] fileFolders = (File[])this.docRoots.getArray();
        if (fileFolders == null) {
            return false;
        }
        File resource = null;
        for (int i = 0; i < fileFolders.length; ++i) {
            File f;
            File webDir = fileFolders[i];
            resource = new File(webDir, uri);
            boolean exists = resource.exists();
            boolean isDirectory = resource.isDirectory();
            if (exists && isDirectory && (f = new File(resource, "/index.html")).exists()) {
                resource = f;
                found = true;
                break;
            }
            if (!isDirectory && exists) {
                found = true;
                break;
            }
            found = false;
        }
        if (!found) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "File not found {0}", resource);
            }
            return false;
        }
        if (!Method.GET.equals(request.getMethod())) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "File found {0}, but HTTP method {1} is not allowed", new Object[]{resource, request.getMethod()});
            }
            response.setStatus(HttpStatus.METHOD_NOT_ALLOWED_405);
            response.setHeader(Header.Allow, "GET");
            return true;
        }
        StaticHttpHandler.pickupContentType(response, resource);
        this.addToFileCache(request, response, resource);
        StaticHttpHandler.sendFile(response, resource);
        return true;
    }

    private FileCacheFilter lookupFileCache(FilterChainContext fcContext) {
        Filter filter;
        FilterChain fc = fcContext.getFilterChain();
        int lastFileCacheIdx = this.fileCacheFilterIdx;
        if (lastFileCacheIdx != -1 && (filter = (Filter)fc.get(lastFileCacheIdx)) instanceof FileCacheFilter) {
            return (FileCacheFilter)filter;
        }
        int size = fc.size();
        for (int i = 0; i < size; ++i) {
            Filter filter2 = (Filter)fc.get(i);
            if (!(filter2 instanceof FileCacheFilter)) continue;
            this.fileCacheFilterIdx = i;
            return (FileCacheFilter)filter2;
        }
        this.fileCacheFilterIdx = -1;
        return null;
    }

    private static void pickupContentType(Response response, File file) {
        if (!response.getResponse().isContentTypeSet()) {
            String substr;
            String path = file.getPath();
            int dot = path.lastIndexOf(46);
            if (dot < 0) {
                substr = file.toString();
                dot = substr.lastIndexOf(46);
            } else {
                substr = path;
            }
            if (dot > 0) {
                String ext = substr.substring(dot + 1);
                String ct = MimeType.get(ext);
                if (ct != null) {
                    response.setContentType(ct);
                }
            } else {
                response.setContentType(MimeType.get("html"));
            }
        }
    }

    private static void addCachingHeaders(Response response, File file) {
        StringBuilder sb = new StringBuilder();
        long contentLength = file.length();
        long lastModified = file.lastModified();
        if (contentLength >= 0L || lastModified >= 0L) {
            sb.append('\"').append(contentLength).append('-').append(lastModified).append('\"');
            response.setHeader(Header.ETag, sb.toString());
        }
        response.addDateHeader(Header.LastModified, lastModified);
    }

    private static class NonBlockingDownloadHandler
    implements WriteHandler {
        private volatile long size;
        private final Response response;
        private final NIOOutputStream outputStream;
        private final FileChannel fileChannel;
        private final MemoryManager mm;
        private final int chunkSize;

        NonBlockingDownloadHandler(Response response, NIOOutputStream outputStream, File file, int chunkSize) {
            try {
                this.fileChannel = new FileInputStream(file).getChannel();
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("File should have existed", e);
            }
            this.size = file.length();
            this.response = response;
            this.outputStream = outputStream;
            this.mm = response.getRequest().getContext().getMemoryManager();
            this.chunkSize = chunkSize;
        }

        public void onWritePossible() throws Exception {
            LOGGER.log(Level.FINE, "[onWritePossible]");
            boolean isWriteMore = this.sendChunk();
            if (isWriteMore) {
                this.outputStream.notifyCanWrite(this, this.chunkSize * 3 / 2);
            }
        }

        public void onError(Throwable t) {
            LOGGER.log(Level.WARNING, "[onError] ", t);
            this.response.setStatus(500, t.getMessage());
            this.complete(true);
        }

        private boolean sendChunk() throws IOException {
            Buffer buffer = this.mm.allocate(this.chunkSize);
            buffer.allowBufferDispose(true);
            int justReadBytes = this.fileChannel.read(buffer.toByteBuffer());
            if (justReadBytes <= 0) {
                this.complete(false);
                return false;
            }
            buffer.position(justReadBytes);
            buffer.trim();
            this.outputStream.write(buffer);
            this.size -= (long)justReadBytes;
            if (this.size <= 0L) {
                this.complete(false);
                return false;
            }
            return true;
        }

        private void complete(boolean isError) {
            block7: {
                block6: {
                    try {
                        this.fileChannel.close();
                    }
                    catch (IOException e) {
                        if (isError) break block6;
                        this.response.setStatus(500, e.getMessage());
                    }
                }
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    if (isError) break block7;
                    this.response.setStatus(500, e.getMessage());
                }
            }
            if (this.response.isSuspended()) {
                this.response.resume();
            } else {
                this.response.finish();
            }
        }
    }
}

