/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.resources.ReflectionCache;

public class RequiredAnnotationDiscovery
implements Service {
    private final ReflectionCache cache;

    public RequiredAnnotationDiscovery(ReflectionCache cache) {
        this.cache = cache;
    }

    public boolean containsAnnotation(BackedAnnotatedType<?> annotatedType, Class<? extends Annotation> requiredAnnotation) {
        if (this.containsAnnotations(annotatedType.getAnnotations(), requiredAnnotation, true)) {
            return true;
        }
        for (Class<?> clazz = annotatedType.getJavaClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!this.containsAnnotations(this.cache.getAnnotations(field), requiredAnnotation)) continue;
                return true;
            }
            for (AccessibleObject accessibleObject : clazz.getConstructors()) {
                if (this.containsAnnotations(this.cache.getAnnotations(accessibleObject), requiredAnnotation)) {
                    return true;
                }
                for (Annotation[] parameterAnnotations : ((Constructor)accessibleObject).getParameterAnnotations()) {
                    if (!this.containsAnnotations(parameterAnnotations, requiredAnnotation)) continue;
                    return true;
                }
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                if (this.containsAnnotations(this.cache.getAnnotations(accessibleObject), requiredAnnotation)) {
                    return true;
                }
                for (Annotation[] parameterAnnotations : ((Method)accessibleObject).getParameterAnnotations()) {
                    if (!this.containsAnnotations(parameterAnnotations, requiredAnnotation)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean containsAnnotations(Annotation[] annotations, Class<? extends Annotation> requiredAnnotation) {
        return this.containsAnnotation(annotations, requiredAnnotation, true);
    }

    private boolean containsAnnotation(Annotation[] annotations, Class<? extends Annotation> requiredAnnotation, boolean checkMetaAnnotations) {
        for (Annotation annotation : annotations) {
            if (!this.containsAnnotation(annotation, requiredAnnotation, checkMetaAnnotations)) continue;
            return true;
        }
        return false;
    }

    private boolean containsAnnotations(Iterable<? extends Annotation> annotations, Class<? extends Annotation> requiredAnnotation, boolean checkMetaAnnotations) {
        for (Annotation annotation : annotations) {
            if (!this.containsAnnotation(annotation, requiredAnnotation, checkMetaAnnotations)) continue;
            return true;
        }
        return false;
    }

    private boolean containsAnnotation(Annotation annotation, Class<? extends Annotation> requiredAnnotation, boolean checkMetaAnnotations) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (requiredAnnotation.equals(annotationType)) {
            return true;
        }
        return checkMetaAnnotations && this.containsAnnotation(this.cache.getAnnotations(annotationType), requiredAnnotation, false);
    }

    public void cleanup() {
    }
}

