/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.ganglia;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import info.ganglia.gmetric4j.gmetric.GMetric;
import info.ganglia.gmetric4j.gmetric.GMetricSlope;
import info.ganglia.gmetric4j.gmetric.GMetricType;
import info.ganglia.gmetric4j.gmetric.GangliaException;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GangliaReporter
extends ScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GangliaReporter.class);
    private final GMetric ganglia;
    private final String prefix;
    private final int tMax;
    private final int dMax;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private GangliaReporter(MetricRegistry registry, GMetric ganglia, String prefix, int tMax, int dMax, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter) {
        super(registry, "ganglia-reporter", filter, rateUnit, durationUnit);
        this.ganglia = ganglia;
        this.prefix = prefix;
        this.tMax = tMax;
        this.dMax = dMax;
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            this.reportGauge(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            this.reportCounter(entry.getKey(), (Counter)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            this.reportHistogram(entry.getKey(), (Histogram)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            this.reportMeter(entry.getKey(), (Meter)entry.getValue());
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            this.reportTimer(entry.getKey(), (Timer)entry.getValue());
        }
    }

    private void reportTimer(String name, Timer timer) {
        String group = this.group(name);
        try {
            Snapshot snapshot = timer.getSnapshot();
            this.announce(this.prefix(name, "max"), group, this.convertDuration(snapshot.getMax()), this.getDurationUnit());
            this.announce(this.prefix(name, "mean"), group, this.convertDuration(snapshot.getMean()), this.getDurationUnit());
            this.announce(this.prefix(name, "min"), group, this.convertDuration(snapshot.getMin()), this.getDurationUnit());
            this.announce(this.prefix(name, "stddev"), group, this.convertDuration(snapshot.getStdDev()), this.getDurationUnit());
            this.announce(this.prefix(name, "p50"), group, this.convertDuration(snapshot.getMedian()), this.getDurationUnit());
            this.announce(this.prefix(name, "p75"), group, this.convertDuration(snapshot.get75thPercentile()), this.getDurationUnit());
            this.announce(this.prefix(name, "p95"), group, this.convertDuration(snapshot.get95thPercentile()), this.getDurationUnit());
            this.announce(this.prefix(name, "p98"), group, this.convertDuration(snapshot.get98thPercentile()), this.getDurationUnit());
            this.announce(this.prefix(name, "p99"), group, this.convertDuration(snapshot.get99thPercentile()), this.getDurationUnit());
            this.announce(this.prefix(name, "p999"), group, this.convertDuration(snapshot.get999thPercentile()), this.getDurationUnit());
            this.reportMetered(name, (Metered)timer, group, "calls");
        }
        catch (GangliaException e) {
            LOGGER.warn("Unable to report timer {}", (Object)name, (Object)e);
        }
    }

    private void reportMeter(String name, Meter meter) {
        String group = this.group(name);
        try {
            this.reportMetered(name, (Metered)meter, group, "events");
        }
        catch (GangliaException e) {
            LOGGER.warn("Unable to report meter {}", (Object)name, (Object)e);
        }
    }

    private void reportMetered(String name, Metered meter, String group, String eventName) throws GangliaException {
        String unit = eventName + '/' + this.getRateUnit();
        this.announce(this.prefix(name, "count"), group, meter.getCount(), eventName);
        this.announce(this.prefix(name, "m1_rate"), group, this.convertRate(meter.getOneMinuteRate()), unit);
        this.announce(this.prefix(name, "m5_rate"), group, this.convertRate(meter.getFiveMinuteRate()), unit);
        this.announce(this.prefix(name, "m15_rate"), group, this.convertRate(meter.getFifteenMinuteRate()), unit);
        this.announce(this.prefix(name, "mean_rate"), group, this.convertRate(meter.getMeanRate()), unit);
    }

    private void reportHistogram(String name, Histogram histogram) {
        String group = this.group(name);
        try {
            Snapshot snapshot = histogram.getSnapshot();
            this.announce(this.prefix(name, "count"), group, histogram.getCount(), "");
            this.announce(this.prefix(name, "max"), group, snapshot.getMax(), "");
            this.announce(this.prefix(name, "mean"), group, snapshot.getMean(), "");
            this.announce(this.prefix(name, "min"), group, snapshot.getMin(), "");
            this.announce(this.prefix(name, "stddev"), group, snapshot.getStdDev(), "");
            this.announce(this.prefix(name, "p50"), group, snapshot.getMedian(), "");
            this.announce(this.prefix(name, "p75"), group, snapshot.get75thPercentile(), "");
            this.announce(this.prefix(name, "p95"), group, snapshot.get95thPercentile(), "");
            this.announce(this.prefix(name, "p98"), group, snapshot.get98thPercentile(), "");
            this.announce(this.prefix(name, "p99"), group, snapshot.get99thPercentile(), "");
            this.announce(this.prefix(name, "p999"), group, snapshot.get999thPercentile(), "");
        }
        catch (GangliaException e) {
            LOGGER.warn("Unable to report histogram {}", (Object)name, (Object)e);
        }
    }

    private void reportCounter(String name, Counter counter) {
        String group = this.group(name);
        try {
            this.announce(this.prefix(name, "count"), group, counter.getCount(), "");
        }
        catch (GangliaException e) {
            LOGGER.warn("Unable to report counter {}", (Object)name, (Object)e);
        }
    }

    private void reportGauge(String name, Gauge gauge) {
        String group = this.group(name);
        Object obj = gauge.getValue();
        try {
            this.ganglia.announce(MetricRegistry.name((String)this.prefix, (String[])new String[]{name}), String.valueOf(obj), this.detectType(obj), "", GMetricSlope.BOTH, this.tMax, this.dMax, group);
        }
        catch (GangliaException e) {
            LOGGER.warn("Unable to report gauge {}", (Object)name, (Object)e);
        }
    }

    private void announce(String name, String group, double value, String units) throws GangliaException {
        this.ganglia.announce(name, Double.toString(value), GMetricType.DOUBLE, units, GMetricSlope.BOTH, this.tMax, this.dMax, group);
    }

    private void announce(String name, String group, long value, String units) throws GangliaException {
        String v = Long.toString(value);
        this.ganglia.announce(name, v, GMetricType.DOUBLE, units, GMetricSlope.BOTH, this.tMax, this.dMax, group);
    }

    private GMetricType detectType(Object o) {
        if (o instanceof Float) {
            return GMetricType.FLOAT;
        }
        if (o instanceof Double) {
            return GMetricType.DOUBLE;
        }
        if (o instanceof Byte) {
            return GMetricType.INT8;
        }
        if (o instanceof Short) {
            return GMetricType.INT16;
        }
        if (o instanceof Integer) {
            return GMetricType.INT32;
        }
        if (o instanceof Long) {
            return GMetricType.DOUBLE;
        }
        return GMetricType.STRING;
    }

    private String group(String name) {
        int i = name.lastIndexOf(46);
        if (i < 0) {
            return "";
        }
        return name.substring(0, i);
    }

    private String prefix(String name, String n) {
        return MetricRegistry.name((String)this.prefix, (String[])new String[]{name, n});
    }

    public static class Builder {
        private final MetricRegistry registry;
        private String prefix;
        private int tMax;
        private int dMax;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.tMax = 60;
            this.dMax = 0;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        public Builder withTMax(int tMax) {
            this.tMax = tMax;
            return this;
        }

        public Builder prefixedWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder withDMax(int dMax) {
            this.dMax = dMax;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public GangliaReporter build(GMetric ganglia) {
            return new GangliaReporter(this.registry, ganglia, this.prefix, this.tMax, this.dMax, this.rateUnit, this.durationUnit, this.filter);
        }
    }
}

