/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.locking;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.locking.LocalLockMediator;
import com.thinkaurelius.titan.diskstorage.locking.LocalLockMediatorProvider;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum LocalLockMediators implements LocalLockMediatorProvider
{
    INSTANCE;

    private static final Logger log;
    private final ConcurrentHashMap<String, LocalLockMediator<?>> mediators = new ConcurrentHashMap();

    @Override
    public <T> LocalLockMediator<T> get(String namespace, TimestampProvider times) {
        Preconditions.checkNotNull((Object)namespace);
        LocalLockMediator<Object> m = this.mediators.get(namespace);
        if (null == m) {
            m = new LocalLockMediator(namespace, times);
            LocalLockMediator<?> old = this.mediators.putIfAbsent(namespace, m);
            if (null != old) {
                m = old;
            } else {
                log.debug("Local lock mediator instantiated for namespace {}", (Object)namespace);
            }
        }
        return m;
    }

    public void clear() {
        this.mediators.clear();
    }

    public void clear(String namespace) {
        Iterator<Map.Entry<String, LocalLockMediator<?>>> iter = this.mediators.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, LocalLockMediator<?>> e = iter.next();
            if (!e.getKey().equals(namespace)) continue;
            iter.remove();
        }
    }

    static {
        log = LoggerFactory.getLogger(LocalLockMediators.class);
    }
}

