/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.util.datastructures;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.util.datastructures.ArraysUtil;
import com.thinkaurelius.titan.util.datastructures.IntSet;

public class ImmutableIntSet
implements IntSet {
    private final int[] values;
    private final int hashcode;

    public ImmutableIntSet(int[] values) {
        Preconditions.checkNotNull((Object)values);
        Preconditions.checkArgument((values.length > 0 ? 1 : 0) != 0);
        this.values = values;
        this.hashcode = ArraysUtil.sum(values);
    }

    public ImmutableIntSet(int value) {
        this(new int[]{value});
    }

    @Override
    public boolean add(int value) {
        throw new UnsupportedOperationException("This IntSet is immutable");
    }

    @Override
    public boolean addAll(int[] values) {
        throw new UnsupportedOperationException("This IntSet is immutable");
    }

    @Override
    public boolean contains(int value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public int[] getAll() {
        return this.values;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IntSet)) {
            return false;
        }
        IntSet oth = (IntSet)other;
        for (int i = 0; i < this.values.length; ++i) {
            if (oth.contains(this.values[i])) continue;
            return false;
        }
        return this.size() == oth.size();
    }
}

