/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.text.highlight;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jboss.forge.addon.text.highlight.Encoder;
import org.jboss.forge.addon.text.highlight.StringScanner;
import org.jboss.forge.addon.text.highlight.scanner.PlainScanner;

public interface Scanner {
    public Type getType();

    public void scan(StringScanner var1, Encoder var2, Map<String, Object> var3);

    public static class Factory {
        private static Factory factory;
        private Map<String, Scanner> registry = new LinkedHashMap<String, Scanner>();

        private Factory() {
        }

        private static Factory instance() {
            if (factory == null) {
                factory = new Factory();
            }
            return factory;
        }

        public static void registrer(Class<? extends Scanner> scanner) {
            Scanner scannerInst = Factory.create(scanner);
            Factory.instance().registry.put(scannerInst.getType().getName(), scannerInst);
        }

        public static Scanner byType(String typeName) {
            for (Scanner scanner : Factory.instance().registry.values()) {
                if (!scanner.getType().getName().equalsIgnoreCase(typeName)) continue;
                return scanner;
            }
            return null;
        }

        public static Scanner byFileName(String fileName) {
            for (Scanner scanner : Factory.instance().registry.values()) {
                if (!scanner.getType().supports(fileName)) continue;
                return scanner;
            }
            return Factory.instance().registry.get(PlainScanner.TYPE);
        }

        private static Scanner create(Class<? extends Scanner> scanner) {
            if (scanner != null) {
                try {
                    return scanner.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not create new instance of " + scanner);
                }
            }
            return null;
        }
    }

    public static class Type {
        private String name;
        private Pattern pattern;

        public Type(String name, String pattern) {
            this(name, Pattern.compile(pattern, 2));
        }

        public Type(String name, Pattern pattern) {
            this.name = name;
            this.pattern = pattern;
        }

        public String getName() {
            return this.name;
        }

        public boolean supports(String fileName) {
            if (this.pattern == null) {
                return false;
            }
            return this.pattern.matcher(fileName).find();
        }
    }
}

