/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.server.metrics;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.tinkerpop.rexster.server.metrics.AbstractHostPortReporterConfig;
import com.tinkerpop.rexster.server.metrics.HostPort;
import com.tinkerpop.rexster.server.metrics.RegexMetricFilter;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;

class GraphiteReporterConfig
extends AbstractHostPortReporterConfig {
    private static final Logger logger = Logger.getLogger(GraphiteReporterConfig.class);
    private final String prefix;
    private final List<GraphiteReporter> reporters = new ArrayList<GraphiteReporter>();

    public GraphiteReporterConfig(HierarchicalConfiguration config, MetricRegistry metricRegistry) {
        super(config, metricRegistry);
        this.hostsString = this.registryConfiguration.getString("hosts", "localhost:2003");
        this.prefix = this.registryConfiguration.getString("prefix", "");
        logger.info((Object)String.format("Configured Graphite Metric Reporter [%s].", this.hostsString));
    }

    @Override
    public List<HostPort> getFullHostList() {
        return this.getHostListAndStringList();
    }

    @Override
    public boolean enable() {
        List<HostPort> hosts = this.getFullHostList();
        if (hosts == null || hosts.isEmpty()) {
            logger.error((Object)"No hosts specified, cannot enable GraphiteReporter");
            return false;
        }
        for (HostPort hostPort : hosts) {
            try {
                logger.info((Object)String.format("Enabling GraphiteReporter to %s:%s", hostPort.getHost(), hostPort.getPort()));
                Graphite graphite = new Graphite(new InetSocketAddress(hostPort.getHost(), hostPort.getPort()));
                GraphiteReporter reporter = GraphiteReporter.forRegistry((MetricRegistry)this.metricRegistry).convertDurationsTo(this.getRealDurationTimeUnitConversion()).convertRatesTo(this.getRealRateTimeUnitConversion()).prefixedWith(this.prefix).filter((MetricFilter)new RegexMetricFilter(this.inclusion, this.exclusion)).build(graphite);
                reporter.start(this.period, this.getRealTimeUnit());
                this.reporters.add(reporter);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to enable GraphiteReporter", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public void disable() {
        for (GraphiteReporter reporter : this.reporters) {
            reporter.stop();
        }
        this.reporters.clear();
    }
}

