/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.aesh;

import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.forge.addon.shell.ShellImpl;
import org.jboss.forge.addon.shell.aesh.CommandLineUtil;
import org.jboss.forge.addon.shell.ui.ShellContext;
import org.jboss.forge.addon.shell.ui.ShellUIPromptImpl;
import org.jboss.forge.addon.shell.util.ShellUtil;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;

public abstract class AbstractShellInteraction
implements Comparable<AbstractShellInteraction> {
    private final String name;
    private final CommandController controller;
    private final UICommandMetadata metadata;
    protected final CommandLineUtil commandLineUtil;
    private final UIContext context;

    protected AbstractShellInteraction(CommandController controller, ShellContext shellContext, CommandLineUtil commandLineUtil) {
        this.context = shellContext;
        this.controller = controller;
        this.metadata = controller.getMetadata();
        this.name = ShellUtil.shellifyName(this.metadata.getName()).toLowerCase();
        this.commandLineUtil = commandLineUtil;
    }

    public abstract CommandLineParser getParser(ShellContext var1, String var2) throws Exception;

    public abstract void promptRequiredMissingValues(ShellImpl var1);

    public UIContext getContext() {
        return this.context;
    }

    public CommandController getController() {
        return this.controller;
    }

    public final String getName() {
        return this.name;
    }

    @Override
    public int compareTo(AbstractShellInteraction o) {
        return this.getName().compareTo(o.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractShellInteraction)) {
            return false;
        }
        AbstractShellInteraction that = (AbstractShellInteraction)o;
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    protected void promptRequiredMissingValues(ShellImpl shell, Iterable<InputComponent<?, ?>> inputs) {
        ShellUIPromptImpl prompt = shell.createPrompt(this.context);
        for (InputComponent<?, ?> input : inputs) {
            Object obj;
            if (input.isRequired() && !input.hasDefaultValue() && !input.hasValue() && (obj = prompt.promptValueFrom(input)) == null) break;
        }
    }
}

