/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.prefix;

import java.util.Collections;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.prefix.PluginPrefixRequest;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

public class DefaultPluginPrefixRequest
implements PluginPrefixRequest {
    private String prefix;
    private List<String> pluginGroups = Collections.emptyList();
    private Model pom;
    private List<RemoteRepository> repositories = Collections.emptyList();
    private RepositorySystemSession session;

    public DefaultPluginPrefixRequest() {
    }

    public DefaultPluginPrefixRequest(String prefix, MavenSession session) {
        this.setPrefix(prefix);
        this.setRepositorySession(session.getRepositorySession());
        MavenProject project = session.getCurrentProject();
        if (project != null) {
            this.setRepositories((List)project.getRemotePluginRepositories());
            this.setPom(project.getModel());
        }
        this.setPluginGroups((List)session.getPluginGroups());
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public DefaultPluginPrefixRequest setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public List<String> getPluginGroups() {
        return this.pluginGroups;
    }

    @Override
    public DefaultPluginPrefixRequest setPluginGroups(List<String> pluginGroups) {
        this.pluginGroups = pluginGroups != null ? pluginGroups : Collections.emptyList();
        return this;
    }

    @Override
    public Model getPom() {
        return this.pom;
    }

    @Override
    public DefaultPluginPrefixRequest setPom(Model pom) {
        this.pom = pom;
        return this;
    }

    @Override
    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    @Override
    public DefaultPluginPrefixRequest setRepositories(List<RemoteRepository> repositories) {
        this.repositories = repositories != null ? repositories : Collections.emptyList();
        return this;
    }

    @Override
    public RepositorySystemSession getRepositorySession() {
        return this.session;
    }

    @Override
    public DefaultPluginPrefixRequest setRepositorySession(RepositorySystemSession session) {
        this.session = session;
        return this;
    }
}

