/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.client;

import com.tinkerpop.rexster.client.RexProClientFilter;
import com.tinkerpop.rexster.client.RexsterClient;
import com.tinkerpop.rexster.client.RexsterClientHandler;
import java.util.Map;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.log4j.Logger;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.strategies.LeaderFollowerNIOStrategy;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public class RexsterClientFactory {
    private static final Logger logger = Logger.getLogger(RexsterClientFactory.class);
    private static final BaseConfiguration defaultConfiguration = new BaseConfiguration(){
        {
            this.addProperty("hostname", "localhost");
            this.addProperty("port", 8184);
            this.addProperty("timeout-connection-ms", 8000);
            this.addProperty("timeout-write-ms", 4000);
            this.addProperty("timeout-read-ms", 16000);
            this.addProperty("max-async-write-queue-size", 512000);
            this.addProperty("message-retry-count", 16);
            this.addProperty("message-retry-wait-ms", 50);
            this.addProperty("language", "groovy");
            this.addProperty("graph-obj-name", "g");
            this.addProperty("graph-name", null);
            this.addProperty("transaction", true);
            this.addProperty("serializer", (byte)0);
        }
    };
    private static TCPNIOTransport transport;

    public static RexsterClient open() throws Exception {
        return RexsterClientFactory.open((Configuration)defaultConfiguration);
    }

    public static RexsterClient open(String host) throws Exception {
        BaseConfiguration specificConfiguration = new BaseConfiguration();
        specificConfiguration.addProperty("hostname", (Object)host);
        return RexsterClientFactory.open((Configuration)specificConfiguration);
    }

    public static RexsterClient open(String host, int port) throws Exception {
        BaseConfiguration specificConfiguration = new BaseConfiguration();
        specificConfiguration.addProperty("hostname", (Object)host);
        specificConfiguration.addProperty("port", (Object)port);
        return RexsterClientFactory.open((Configuration)specificConfiguration);
    }

    public static RexsterClient open(String host, String graphName) throws Exception {
        BaseConfiguration specificConfiguration = new BaseConfiguration();
        specificConfiguration.addProperty("hostname", (Object)host);
        specificConfiguration.addProperty("graph-name", (Object)graphName);
        return RexsterClientFactory.open((Configuration)specificConfiguration);
    }

    public static RexsterClient open(String host, int port, String graphName) throws Exception {
        BaseConfiguration specificConfiguration = new BaseConfiguration();
        specificConfiguration.addProperty("hostname", (Object)host);
        specificConfiguration.addProperty("port", (Object)port);
        specificConfiguration.addProperty("graph-name", (Object)graphName);
        return RexsterClientFactory.open((Configuration)specificConfiguration);
    }

    public static RexsterClient open(Map<String, Object> configuration) throws Exception {
        return RexsterClientFactory.open((Configuration)new MapConfiguration(configuration));
    }

    public static synchronized RexsterClient open(Configuration specificConfiguration) throws Exception {
        CompositeConfiguration jointConfig = new CompositeConfiguration();
        jointConfig.addConfiguration(specificConfiguration);
        jointConfig.addConfiguration((Configuration)defaultConfiguration);
        RexsterClient client = new RexsterClient((Configuration)jointConfig, RexsterClientFactory.getTransport());
        logger.info((Object)String.format("Create RexsterClient instance: [%s]", ConfigurationUtils.toString((Configuration)jointConfig)));
        return client;
    }

    private static synchronized TCPNIOTransport getTransport() throws Exception {
        if (transport == null) {
            RexsterClientHandler handler = new RexsterClientHandler();
            FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
            filterChainBuilder.add((Filter)new TransportFilter());
            filterChainBuilder.add((Filter)new RexProClientFilter());
            filterChainBuilder.add((Filter)handler);
            transport = TCPNIOTransportBuilder.newInstance().build();
            transport.setIOStrategy((IOStrategy)LeaderFollowerNIOStrategy.getInstance());
            ThreadPoolConfig workerThreadPoolConfig = ThreadPoolConfig.defaultConfig().setCorePoolSize(4).setMaxPoolSize(12);
            transport.setWorkerThreadPoolConfig(workerThreadPoolConfig);
            ThreadPoolConfig kernalThreadPoolConfig = ThreadPoolConfig.defaultConfig().setCorePoolSize(4).setMaxPoolSize(12);
            transport.setKernelThreadPoolConfig(kernalThreadPoolConfig);
            transport.setProcessor((Processor)filterChainBuilder.build());
            transport.start();
        }
        return transport;
    }
}

