/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.validate;

import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.validate.UIValidator;
import org.jboss.forge.furnace.util.Assert;

public class CompositeUIValidator
implements UIValidator {
    private final List<UIValidator> validators = new ArrayList<UIValidator>();

    public CompositeUIValidator(Iterable<? extends UIValidator> validators) {
        Assert.notNull(validators, (String)"Validators should not be null");
        for (UIValidator uIValidator : validators) {
            Assert.notNull((Object)uIValidator, (String)"Validator should not be null");
            this.validators.add(uIValidator);
        }
    }

    public CompositeUIValidator(UIValidator firstValidator, UIValidator ... validators) {
        Assert.notNull((Object)firstValidator, (String)"Validator should not be null");
        this.validators.add(firstValidator);
        Assert.notNull((Object)validators, (String)"Validators should not be null");
        for (UIValidator validator : validators) {
            Assert.notNull((Object)validator, (String)"Validator should not be null");
            this.validators.add(validator);
        }
    }

    @Override
    public void validate(UIValidationContext context) {
        for (UIValidator validator : this.validators) {
            validator.validate(context);
        }
    }
}

