/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl.ui;

import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.manager.impl.ui.AddonCommandConstants;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.Projects;
import org.jboss.forge.addon.projects.building.BuildException;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.manager.AddonManager;
import org.jboss.forge.furnace.manager.request.InstallRequest;
import org.jboss.forge.furnace.manager.request.RemoveRequest;
import org.jboss.forge.furnace.util.Addons;

public class AddonBuildAndInstallCommand
extends AbstractUICommand
implements AddonCommandConstants {
    @Inject
    private AddonManager addonManager;
    @Inject
    @WithAttributes(label="Project directory", description="The location of the project (contains pom.xml)", required=true)
    private UIInput<DirectoryResource> projectRoot;
    @Inject
    private ProjectFactory projectFactory;
    @Inject
    private AddonRegistry registry;

    public Metadata getMetadata(UIContext context) {
        boolean gui = context.getProvider().isGUI();
        return Metadata.from((UICommandMetadata)super.getMetadata(context), this.getClass()).name(gui ? "Build and Install an Addon" : "addon-build-and-install").description("Command to build and install a Furnace 2 addon.").category(Categories.create((String[])ADDON_MANAGER_CATEGORIES));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = Projects.getSelectedProject((ProjectFactory)this.projectFactory, (UIContext)builder.getUIContext());
        if (project != null) {
            this.projectRoot.setDefaultValue((Object)project.getRootDirectory());
        }
        builder.add(this.projectRoot);
    }

    public Result execute(UIExecutionContext context) {
        Project project = this.projectFactory.findProject((Resource)this.projectRoot.getValue());
        if (project == null) {
            return Results.fail((String)("No project found in root " + ((DirectoryResource)this.projectRoot.getValue()).getFullyQualifiedName()));
        }
        Coordinate coordinate = ((MetadataFacet)project.getFacet(MetadataFacet.class)).getOutputDependency().getCoordinate();
        try {
            ((PackagingFacet)project.getFacet(PackagingFacet.class)).createBuilder().runTests(false).addArguments(new String[]{"clean", "install"}).build();
        }
        catch (BuildException e) {
            return Results.fail((String)"Unable to execute project build", (Throwable)e);
        }
        try {
            AddonId id = AddonId.from((String)(coordinate.getGroupId() + ":" + coordinate.getArtifactId()), (String)coordinate.getVersion());
            RemoveRequest removeRequest = this.addonManager.remove(id);
            removeRequest.perform();
            Addons.waitUntilStopped((Addon)this.registry.getAddon(id));
            InstallRequest installRequest = this.addonManager.install(id);
            installRequest.perform();
            return Results.success((String)("Addon " + coordinate.toString() + " was installed successfully."));
        }
        catch (Throwable t) {
            return Results.fail((String)("Addon " + coordinate.toString() + " could not be installed."), (Throwable)t);
        }
    }
}

