/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.parser.java.utils;

import java.util.Arrays;
import java.util.List;
import org.jboss.forge.addon.parser.java.utils.IdentifierType;
import org.jboss.forge.addon.parser.java.utils.ResultType;
import org.jboss.forge.addon.parser.java.utils.ValidationResult;
import org.jboss.forge.furnace.util.Strings;

public class JLSValidator {
    private static final List<String> JAVA_KEYWORDS = Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while");
    private static final List<String> BOOLEAN_LITERALS = Arrays.asList("true", "false");
    private static final String NULL_LITERAL = "null";

    private JLSValidator() {
    }

    public static ValidationResult validateVariableName(String identifier) {
        if (Strings.isNullOrEmpty((String)identifier)) {
            return new ValidationResult(ResultType.ERROR, Messages.notNullOrEmpty(IdentifierType.VARIABLE_NAME));
        }
        return JLSValidator.validateIdentifier(identifier, IdentifierType.VARIABLE_NAME);
    }

    public static ValidationResult validateClassName(String className) {
        if (Strings.isNullOrEmpty((String)className)) {
            return new ValidationResult(ResultType.ERROR, Messages.notNullOrEmpty(IdentifierType.CLASS_NAME));
        }
        int indexOfDot = className.lastIndexOf(".");
        if (indexOfDot == -1) {
            return JLSValidator.validateIdentifier(className, IdentifierType.CLASS_NAME);
        }
        String packageSequence = className.substring(0, indexOfDot);
        ValidationResult result = JLSValidator.validatePackageName(packageSequence);
        if (!result.getType().equals((Object)ResultType.INFO)) {
            return result;
        }
        String classSequence = className.substring(indexOfDot + 1);
        return JLSValidator.validateIdentifier(classSequence, IdentifierType.CLASS_NAME);
    }

    public static ValidationResult validatePackageName(String packageName) {
        String[] names;
        if (Strings.isNullOrEmpty((String)packageName)) {
            return new ValidationResult(ResultType.ERROR, Messages.notNullOrEmpty(IdentifierType.PACKAGE_NAME));
        }
        int indexOfDot = packageName.indexOf(".");
        if (indexOfDot == -1) {
            return JLSValidator.validateIdentifier(packageName, IdentifierType.PACKAGE_NAME);
        }
        if (indexOfDot == 0) {
            return new ValidationResult(ResultType.ERROR, "The package name must not start with a '.'");
        }
        if (packageName.charAt(packageName.length() - 1) == '.') {
            return new ValidationResult(ResultType.ERROR, "The package name must not end with a '.'");
        }
        for (String name : names = packageName.split("[.]")) {
            if (Strings.isNullOrEmpty((String)name)) {
                return new ValidationResult(ResultType.ERROR, Messages.isInvalidPackageName(packageName));
            }
            ValidationResult result = JLSValidator.validateIdentifier(name, IdentifierType.PACKAGE_NAME);
            if (result.getType().equals((Object)ResultType.INFO)) continue;
            return result;
        }
        return new ValidationResult(ResultType.INFO);
    }

    public static ValidationResult validateIdentifier(String identifier, IdentifierType type) {
        if (Strings.isNullOrEmpty((String)identifier)) {
            return new ValidationResult(ResultType.ERROR, Messages.notNullOrEmpty(type));
        }
        if (JLSValidator.isReservedWord(identifier)) {
            return new ValidationResult(ResultType.ERROR, Messages.isAJavaKeyWord(identifier));
        }
        int javaLetter = identifier.codePointAt(0);
        if (!Character.isJavaIdentifierStart(javaLetter)) {
            return new ValidationResult(ResultType.ERROR, Messages.containsInvalidCharacters(identifier));
        }
        for (int ctr = 1; ctr < identifier.length(); ++ctr) {
            int javaLetterOrDigit = identifier.codePointAt(ctr);
            if (Character.isJavaIdentifierPart(javaLetterOrDigit)) continue;
            return new ValidationResult(ResultType.ERROR, Messages.containsInvalidCharacters(identifier));
        }
        if (IdentifierType.CLASS_NAME.equals((Object)type) && identifier.contains("$")) {
            return new ValidationResult(ResultType.WARNING, "The use of '$' in class names is discouraged.");
        }
        return new ValidationResult(ResultType.INFO);
    }

    public static boolean isReservedWord(String word) {
        return JAVA_KEYWORDS.contains(word) || BOOLEAN_LITERALS.contains(word) || NULL_LITERAL.equals(word);
    }

    static class Messages {
        Messages() {
        }

        static String notNullOrEmpty(IdentifierType type) {
            StringBuilder builder = new StringBuilder();
            switch (type) {
                case CLASS_NAME: {
                    builder.append("Class name");
                    break;
                }
                case PACKAGE_NAME: {
                    builder.append("Package name");
                    break;
                }
                case VARIABLE_NAME: {
                    builder.append("Identifier");
                    break;
                }
            }
            builder.append(" cannot be empty");
            return builder.toString();
        }

        static String isAJavaKeyWord(String identifier) {
            return identifier + " is a keyword.";
        }

        static String containsInvalidCharacters(String identifier) {
            return identifier + " is not a valid Java identifier.";
        }

        static String isInvalidPackageName(String packageName) {
            return packageName + " is not a valid Java package.";
        }
    }
}

