/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.text.highlight;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringScanner {
    private StringSequence sequence;

    public StringScanner(String source) {
        this.sequence = new StringSequence(source);
    }

    public MatchResult scan(String pattern) {
        return this.scan(Pattern.compile(pattern));
    }

    public MatchResult scan(Pattern pattern) {
        Matcher m = pattern.matcher(this.sequence);
        if (m.lookingAt()) {
            StaticMatchResult result = new StaticMatchResult(this.sequence, m);
            this.sequence.advance(m.end());
            return result;
        }
        return null;
    }

    public MatchResult scanUntil(String pattern) {
        return this.scanUntil(Pattern.compile(pattern));
    }

    public MatchResult scanUntil(Pattern pattern) {
        Matcher m = pattern.matcher(this.sequence);
        if (m.find()) {
            UntilStaticMatchResult result = new UntilStaticMatchResult(this.sequence, m);
            this.sequence.advance(m.end());
            return result;
        }
        return null;
    }

    public MatchResult check(String pattern) {
        return this.check(Pattern.compile(pattern));
    }

    public MatchResult check(Pattern pattern) {
        Matcher m = pattern.matcher(this.sequence);
        if (m.lookingAt()) {
            return new StaticMatchResult(this.sequence, m);
        }
        return null;
    }

    public String next() {
        return this.sequence.pop();
    }

    public boolean hasMore() {
        return this.sequence.hasMore();
    }

    public String peek(int length) {
        return this.sequence.peek(length);
    }

    public int column(int pos) {
        int currPrePos = 0;
        while (pos + currPrePos > 0 && !this.sequence.peek(pos, currPrePos).startsWith("\n")) {
            --currPrePos;
        }
        return currPrePos * -1;
    }

    public int index() {
        return this.sequence.index();
    }

    public boolean isBeginningOfLine() {
        if (this.sequence.index() == 0) {
            return true;
        }
        return "\n".equals(this.sequence.peek(-1));
    }

    private static class StringSequence
    implements CharSequence {
        private String source;
        private int index;

        public StringSequence(String source) {
            this.source = source;
            this.index = 0;
        }

        @Override
        public int length() {
            return this.source.length() - this.index;
        }

        @Override
        public char charAt(int index) {
            return this.source.charAt(this.index + index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.source.subSequence(this.index + start, this.index + end);
        }

        public CharSequence subSequence(int index, int start, int end) {
            return this.source.subSequence(index + start, index + end);
        }

        public String peek(int length) {
            return this.peek(this.index, length);
        }

        public String peek(int pos, int length) {
            if (length < 0) {
                return this.source.substring(pos + length, pos);
            }
            return this.source.substring(pos, pos + length);
        }

        public String pop() {
            return String.valueOf(this.source.charAt(this.index++));
        }

        public int index() {
            return this.index;
        }

        public void advance(int length) {
            this.index += length;
        }

        public boolean hasMore() {
            return this.index < this.source.length();
        }
    }

    private static class UntilStaticMatchResult
    extends StaticMatchResult {
        public UntilStaticMatchResult(StringSequence sequence, MatchResult result) {
            super(sequence, result);
        }

        @Override
        public int start() {
            return 0;
        }

        @Override
        public int start(int group) {
            if (group == 0) {
                return 0;
            }
            return this.originalMatch.start(group);
        }

        @Override
        public String group() {
            int start = 0;
            int end = this.originalMatch.end();
            return (String)this.sequence.subSequence(this.previousIndex, start, end);
        }

        @Override
        public String group(int group) {
            int start = this.originalMatch.start(group);
            if (start == -1) {
                return null;
            }
            if (group == 0) {
                start = 0;
            }
            int end = this.originalMatch.end(group);
            return (String)this.sequence.subSequence(this.previousIndex, start, end);
        }
    }

    private static class StaticMatchResult
    implements MatchResult {
        protected StringSequence sequence;
        protected int previousIndex;
        protected MatchResult originalMatch;

        public StaticMatchResult(StringSequence sequence, MatchResult result) {
            this.originalMatch = result;
            this.sequence = sequence;
            this.previousIndex = sequence.index();
        }

        @Override
        public int end() {
            return this.originalMatch.end();
        }

        @Override
        public int end(int group) {
            return this.originalMatch.end(group);
        }

        @Override
        public int groupCount() {
            return this.originalMatch.groupCount();
        }

        @Override
        public int start() {
            return this.originalMatch.start();
        }

        @Override
        public int start(int group) {
            return this.originalMatch.start(group);
        }

        @Override
        public String group() {
            int start = this.originalMatch.start();
            if (start == -1) {
                return null;
            }
            int end = this.originalMatch.end();
            return (String)this.sequence.subSequence(this.previousIndex, start, end);
        }

        @Override
        public String group(int group) {
            int start = this.originalMatch.start(group);
            if (start == -1) {
                return null;
            }
            int end = this.originalMatch.end(group);
            return (String)this.sequence.subSequence(this.previousIndex, start, end);
        }

        public String toString() {
            return this.group();
        }
    }
}

