/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.text.highlight.scanner;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.jboss.forge.addon.text.highlight.Encoder;
import org.jboss.forge.addon.text.highlight.Options;
import org.jboss.forge.addon.text.highlight.Scanner;
import org.jboss.forge.addon.text.highlight.StringScanner;
import org.jboss.forge.addon.text.highlight.Syntax;
import org.jboss.forge.addon.text.highlight.TokenType;
import org.jboss.forge.addon.text.highlight.WordList;
import org.jboss.forge.addon.text.highlight.scanner.CSSScanner;
import org.jboss.forge.addon.text.highlight.scanner.JavaScriptScanner;

public class HTMLScanner
implements Scanner {
    public static final String[] EVENT_ATTRIBUTES = new String[]{"onabort", "onafterprint", "onbeforeprint", "onbeforeunload", "onblur", "oncanplay", "oncanplaythrough", "onchange", "onclick", "oncontextmenu", "oncuechange", "ondblclick", "ondrag", "ondragdrop", "ondragend", "ondragenter", "ondragleave", "ondragover", "ondragstart", "ondrop", "ondurationchange", "onemptied", "onended", "onerror", "onfocus", "onformchange", "onforminput", "onhashchange", "oninput", "oninvalid", "onkeydown", "onkeypress", "onkeyup", "onload", "onloadeddata", "onloadedmetadata", "onloadstart", "onmessage", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onmousewheel", "onmove", "onoffline", "ononline", "onpagehide", "onpageshow", "onpause", "onplay", "onplaying", "onpopstate", "onprogress", "onratechange", "onreadystatechange", "onredo", "onreset", "onresize", "onscroll", "onseeked", "onseeking", "onselect", "onshow", "onstalled", "onstorage", "onsubmit", "onsuspend", "ontimeupdate", "onundo", "onunload", "onvolumechange", "onwaiting"};
    public static final Pattern ATTR_NAME = Pattern.compile("[\\w.:-]+");
    public static final Pattern TAG_END = Pattern.compile("\\/?>");
    public static final Pattern HEX = Pattern.compile("[0-9a-fA-F]");
    public static final Pattern ENTITY = Pattern.compile("&(?:\\w+|\\#(?:\\d+|x" + HEX.pattern() + "+));");
    public static final Pattern SPACE = Pattern.compile("\\s+", 32);
    public static final Pattern CDATA_START = Pattern.compile("<!\\[CDATA\\[");
    public static final Pattern CDATA_END = Pattern.compile(".*?\\]\\]>", 32);
    public static final Pattern CDATA_ERROR = Pattern.compile(".+");
    public static final Pattern COMMENT = Pattern.compile("<!--(?:.*?-->|.*)", 32);
    public static final Pattern DOCTYPE = Pattern.compile("<!(\\w+)(?:.*?>|.*)|\\]>", 32);
    public static final Pattern PRE_PROCESSOR = Pattern.compile("<\\?xml(?:.*?\\?>|.*)");
    public static final Pattern COMMENT2 = Pattern.compile("<\\?(?:.*?\\?>|.*)", 32);
    public static final Pattern TAG = Pattern.compile("<\\/[-\\w.:]*>?", 32);
    public static final Pattern SPECIAL_TAG = Pattern.compile("<(?:(script|style)|[-\\w.:]+)(>)?", 32);
    public static final Pattern PLAIN = Pattern.compile("[^<>&]+");
    public static final Pattern ERROR = Pattern.compile("[<>&]");
    public static final Pattern EQUAL = Pattern.compile("=");
    public static final Pattern QUOTE = Pattern.compile("[\"']");
    public static final Pattern JAVASCRIPT_INLINE = Pattern.compile("javascript:[ \\t]*");
    public static final Pattern AMP = Pattern.compile("&");
    public static final Pattern END = Pattern.compile("[\\n>]");
    public static final Pattern SPECIAL_SPACE = Pattern.compile("[ \\t]*\\n");
    public static final Pattern SPECIAL_COMMENT = Pattern.compile("(\\s*<!--)(?:(.*?)(-->)|(.*))", 32);
    public static final Map<String, Pattern> PLAIN_STRING_CONTENT = new HashMap<String, Pattern>();
    public static final WordList<EmbeddedType> IN_ATTRIBUTE = new WordList<Object>(null, true).add(EVENT_ATTRIBUTES, EmbeddedType.script).add(new String[]{"style"}, EmbeddedType.style);
    public static final Scanner.Type TYPE = new Scanner.Type("HTML", "\\.(html|htm|xhtml)$");

    public HTMLScanner() {
        PLAIN_STRING_CONTENT.put("'", Pattern.compile("[^&'>\\n]+"));
        PLAIN_STRING_CONTENT.put("\"", Pattern.compile("[^&\">\\n]+"));
    }

    @Override
    public Scanner.Type getType() {
        return TYPE;
    }

    @Override
    public void scan(StringScanner source, Encoder encoder, Map<String, Object> options) {
        State state = State.initial;
        EmbeddedType in_attribute = null;
        String in_tag = null;
        Pattern plain_string_content = null;
        block8: while (source.hasMore()) {
            MatchResult m = null;
            if (state != State.in_special_tag && (m = source.scan(SPACE)) != null) {
                encoder.textToken(m.group(), TokenType.space);
                continue;
            }
            switch (state) {
                case initial: {
                    m = source.scan(CDATA_START);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.inline_delimiter);
                        m = source.scan(CDATA_END);
                        if (m != null) {
                            encoder.textToken(m.group().substring(0, m.group().length() - 3), TokenType.plain);
                            encoder.textToken("]]>", TokenType.inline_delimiter);
                            continue block8;
                        }
                        m = source.scan(CDATA_ERROR);
                        if (m == null) continue block8;
                        encoder.textToken(m.group(), TokenType.error);
                        continue block8;
                    }
                    m = source.scan(COMMENT);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.comment);
                        continue block8;
                    }
                    m = source.scan(DOCTYPE);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.doctype);
                        continue block8;
                    }
                    m = source.scan(PRE_PROCESSOR);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.preprocessor);
                        continue block8;
                    }
                    m = source.scan(COMMENT2);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.comment);
                        continue block8;
                    }
                    m = source.scan(TAG);
                    if (m != null) {
                        in_tag = null;
                        encoder.textToken(m.group(), TokenType.tag);
                        continue block8;
                    }
                    m = source.scan(SPECIAL_TAG);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.tag);
                        in_tag = m.group(1);
                        if (m.group(2) != null) {
                            if (in_tag == null) continue block8;
                            state = State.in_special_tag;
                            continue block8;
                        }
                        state = State.attribute;
                        continue block8;
                    }
                    m = source.scan(PLAIN);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.plain);
                        continue block8;
                    }
                    m = source.scan(ENTITY);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.entity);
                        continue block8;
                    }
                    m = source.scan(ERROR);
                    if (m != null) {
                        in_tag = null;
                        encoder.textToken(m.group(), TokenType.error);
                        continue block8;
                    }
                    throw new RuntimeException("[BUG] else-case reached with state " + (Object)((Object)state) + " in " + this.getClass());
                }
                case attribute: {
                    m = source.scan(TAG_END);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.tag);
                        in_attribute = null;
                        if (in_tag != null) {
                            state = State.in_special_tag;
                            continue block8;
                        }
                        state = State.initial;
                        continue block8;
                    }
                    m = source.scan(ATTR_NAME);
                    if (m != null) {
                        in_attribute = IN_ATTRIBUTE.lookup(m.group());
                        encoder.textToken(m.group(), TokenType.attribute_name);
                        state = State.attribute_equal;
                        continue block8;
                    }
                    in_tag = null;
                    encoder.textToken(source.next(), TokenType.error);
                    continue block8;
                }
                case attribute_equal: {
                    m = source.scan(EQUAL);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.operator);
                        state = State.attribute_value;
                    } else {
                        state = State.attribute;
                        continue block8;
                    }
                }
                case attribute_value: {
                    m = source.scan(ATTR_NAME);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.attribute_value);
                        state = State.attribute;
                        continue block8;
                    }
                    m = source.scan(QUOTE);
                    if (m != null) {
                        if (EmbeddedType.script == in_attribute || EmbeddedType.style == in_attribute) {
                            encoder.beginGroup(TokenType.string);
                            encoder.textToken(m.group(), TokenType.delimiter);
                            String groupStart = m.group();
                            m = source.scan(JAVASCRIPT_INLINE);
                            if (m != null) {
                                encoder.textToken(m.group(), TokenType.comment);
                            }
                            String code = source.scanUntil(Pattern.compile("(?=" + groupStart + "|\\z)")).group();
                            if (EmbeddedType.script == in_attribute) {
                                Syntax.Builder.create().scannerType(JavaScriptScanner.TYPE.getName()).encoder(encoder).execute(code);
                            } else {
                                Syntax.Builder.create().scannerType(CSSScanner.TYPE.getName()).encoder(encoder).scannerOptions(Options.create().add("state", (Object)CSSScanner.State.block)).execute(code);
                            }
                            m = source.scan(QUOTE);
                            if (m != null) {
                                encoder.textToken(m.group(), TokenType.delimiter);
                            }
                            encoder.endGroup(TokenType.string);
                            state = State.attribute;
                            in_attribute = null;
                            continue block8;
                        }
                        encoder.beginGroup(TokenType.string);
                        state = State.attribute_value_string;
                        plain_string_content = PLAIN_STRING_CONTENT.get(m.group());
                        encoder.textToken(m.group(), TokenType.delimiter);
                        continue block8;
                    }
                    m = source.scan(TAG_END);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.tag);
                        state = State.initial;
                        continue block8;
                    }
                    encoder.textToken(source.next(), TokenType.error);
                    continue block8;
                }
                case attribute_value_string: {
                    m = source.scan(plain_string_content);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.content);
                        continue block8;
                    }
                    m = source.scan(QUOTE);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.delimiter);
                        encoder.endGroup(TokenType.string);
                        state = State.attribute;
                        continue block8;
                    }
                    m = source.scan(ENTITY);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.entity);
                        continue block8;
                    }
                    m = source.scan(AMP);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.content);
                        continue block8;
                    }
                    m = source.scan(END);
                    if (m == null) continue block8;
                    encoder.endGroup(TokenType.string);
                    state = State.initial;
                    encoder.textToken(m.group(), TokenType.error);
                    continue block8;
                }
                case in_special_tag: {
                    if ("script".equalsIgnoreCase(in_tag) || "style".equalsIgnoreCase(in_tag)) {
                        String code = null;
                        String closing = null;
                        m = source.scan(SPECIAL_SPACE);
                        if (m != null) {
                            encoder.textToken(m.group(), TokenType.space);
                        }
                        if ((m = source.scan(SPECIAL_COMMENT)) != null) {
                            code = m.group(2);
                            if (code == null) {
                                code = m.group(4);
                            }
                            closing = m.group(3);
                            encoder.textToken(m.group(1), TokenType.comment);
                        } else {
                            code = source.scanUntil("(?=(?:\\n\\s*)?<\\/" + in_tag + ">)|\\z").group();
                            closing = null;
                        }
                        if (code != null && !code.isEmpty()) {
                            encoder.beginGroup(TokenType.inline);
                            if ("script".equalsIgnoreCase(in_tag)) {
                                Syntax.Builder.create().scannerType(JavaScriptScanner.TYPE.getName()).encoder(encoder).execute(code);
                            } else {
                                Syntax.Builder.create().scannerType(CSSScanner.TYPE.getName()).encoder(encoder).execute(code);
                            }
                            encoder.endGroup(TokenType.inline);
                        }
                        if (closing != null) {
                            encoder.textToken(closing, TokenType.comment);
                        }
                        state = State.initial;
                        continue block8;
                    }
                    throw new RuntimeException("unknown special tag " + in_tag);
                }
            }
            throw new RuntimeException("Unknown state " + (Object)((Object)state));
        }
    }

    public static enum State {
        initial,
        in_special_tag,
        attribute,
        attribute_equal,
        attribute_value,
        attribute_value_string;

    }

    public static enum EmbeddedType {
        script,
        style;

    }
}

