/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.container.cdi.weld;

import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;

public class AddonResourceLoader
implements ResourceLoader {
    private final Map<String, Class<?>> classes = new ConcurrentHashMap();
    private final Addon addon;

    public AddonResourceLoader(Addon addon) {
        this.addon = addon;
    }

    public String toString() {
        return this.addon.getId().toCoordinates();
    }

    public Class<?> classForName(String name) {
        try {
            if (this.classes.containsKey(name)) {
                return this.classes.get(name);
            }
            Class<?> clazz = this.addon.getClassLoader().loadClass(name);
            this.classes.put(name, clazz);
            return clazz;
        }
        catch (NoClassDefFoundError e) {
            throw new ResourceLoadingException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceLoadingException((Throwable)e);
        }
        catch (LinkageError e) {
            throw new ResourceLoadingException((Throwable)e);
        }
    }

    public void addAdditionalClass(Class<?> clazz) {
        this.classes.put(clazz.getName(), clazz);
    }

    public URL getResource(String name) {
        try {
            return this.addon.getClassLoader().getResource(name);
        }
        catch (Exception e) {
            throw new ResourceLoadingException((Throwable)e);
        }
    }

    public Collection<URL> getResources(String name) {
        try {
            HashSet<URL> resources = new HashSet<URL>();
            Enumeration<URL> urls = this.addon.getClassLoader().getResources(name);
            while (urls.hasMoreElements()) {
                resources.add(urls.nextElement());
            }
            return resources;
        }
        catch (Exception e) {
            throw new ResourceLoadingException((Throwable)e);
        }
    }

    public void cleanup() {
    }
}

