/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.container.cdi.weld;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jboss.weld.resources.spi.ResourceLoader;

public class ModuleScanResult {
    private final ResourceLoader loader;
    private final List<URL> resourceUrls;
    private final Collection<String> classes;

    public ModuleScanResult(ResourceLoader loader, List<URL> discoveredResourceUrls, Collection<String> discoveredClasses) {
        this.loader = loader;
        this.resourceUrls = discoveredResourceUrls;
        this.classes = discoveredClasses;
    }

    public Collection<String> getDiscoveredClasses() {
        return this.classes;
    }

    public List<URL> getDiscoveredResourceUrls() {
        return this.resourceUrls;
    }

    public ResourceLoader getResourceLoader() {
        return this.loader;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.resourceUrls != null) {
            Iterator<Object> iterator = this.resourceUrls.iterator();
            while (iterator.hasNext()) {
                String url = iterator.next().toString();
                result.append(url).append("\n");
            }
        }
        if (this.classes != null) {
            result.append("\n");
            for (String type : this.classes) {
                result.append(type).append("\n");
            }
        }
        return result.toString();
    }
}

