/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.jboss.forge.furnace.util.OperatingSystemUtils;

public class WindupPathUtil {
    public static Path getWindupUserDir() {
        return OperatingSystemUtils.getUserHomeDir().toPath().resolve(".windup");
    }

    public static Path getWindupUserRulesDir() {
        return WindupPathUtil.getWindupUserDir().resolve("rules");
    }

    public static Path getWindupIgnoreListDir() {
        return WindupPathUtil.getWindupUserDir().resolve("ignore");
    }

    public static Path getWindupHome() {
        return Paths.get(System.getProperty("forge.home"), new String[0]);
    }

    public static Path getWindupHomeRules() {
        return WindupPathUtil.getWindupHome().resolve("rules");
    }

    public static Path getWindupHomeIgnoreListDir() {
        return WindupPathUtil.getWindupHome().resolve("ignore");
    }

    public static String cleanFileName(String badFileName) {
        StringBuilder cleanName = new StringBuilder();
        for (int i = 0; i < badFileName.length(); ++i) {
            char c = badFileName.charAt(i);
            if (Character.isJavaIdentifierPart((int)c)) {
                cleanName.append(c);
                continue;
            }
            cleanName.append('_');
        }
        return cleanName.toString();
    }

    public static String classFilePathToClassname(String classFilePath) {
        int pos = classFilePath.lastIndexOf(".class");
        if (pos < 0) {
            throw new IllegalArgumentException("Not a .class file path: " + classFilePath);
        }
        return classFilePath.substring(0, pos).replace('/', '.').replace('\\', '.');
    }
}

