/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.config;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.impls.sparksee.SparkseeGraph;
import com.tinkerpop.rexster.config.GraphConfiguration;
import com.tinkerpop.rexster.config.GraphConfigurationContext;
import com.tinkerpop.rexster.config.GraphConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;

public class SparkseeGraphConfiguration
implements GraphConfiguration {
    private static final String SPARKSEE_CONFIGURATION_PROPERTY = "config-file";

    public Graph configureGraphInstance(GraphConfigurationContext context) throws GraphConfigurationException {
        String sparkseeConfig;
        String graphFile = context.getProperties().getString("graph-location", null);
        if (graphFile == null || graphFile.length() == 0) {
            throw new GraphConfigurationException("Check graph configuration. Missing or empty configuration element: graph-location");
        }
        HierarchicalConfiguration graphSectionConfig = (HierarchicalConfiguration)context.getProperties();
        try {
            SubnodeConfiguration dexSpecificConfiguration = graphSectionConfig.configurationAt("properties");
            sparkseeConfig = dexSpecificConfiguration.getString(SPARKSEE_CONFIGURATION_PROPERTY, null);
        }
        catch (IllegalArgumentException iae) {
            sparkseeConfig = null;
        }
        try {
            return new SparkseeGraph(graphFile, sparkseeConfig);
        }
        catch (Exception ex) {
            throw new GraphConfigurationException((Throwable)ex);
        }
    }
}

