/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.filter;

import com.tinkerpop.rexster.filter.AbstractSecurityFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.XMLConfiguration;

public class DefaultSecurityFilter
extends AbstractSecurityFilter {
    private Map<String, String> users = null;

    @Override
    public boolean authenticate(String username, String password) {
        return this.users.containsKey(username) && this.users.get(username).equals(password);
    }

    @Override
    public void configure(XMLConfiguration configuration) {
        if (this.users == null) {
            this.users = new HashMap<String, String>();
            try {
                SubnodeConfiguration authenticationConfiguration = configuration.configurationAt("security.authentication.configuration.users");
                List userListFromConfiguration = authenticationConfiguration.configurationsAt("user");
                for (HierarchicalConfiguration userFromConfiguration : userListFromConfiguration) {
                    this.users.put(userFromConfiguration.getString("username"), userFromConfiguration.getString("password"));
                }
            }
            catch (Exception e) {
                this.users = null;
                throw new RuntimeException("Invalid configuration of users in configuration file.", e);
            }
        }
    }

    @Override
    public String getName() {
        return "DefaultSecurity";
    }
}

