/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.filter;

import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.tinkerpop.rexster.filter.CharsetHolder;
import java.util.Collections;
import java.util.HashMap;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONObject;

public class HeaderResponseFilter
implements ContainerResponseFilter {
    public static final String HEADER_ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CHARSET = "charset";
    private final String defaultCharacterEncoding;

    public HeaderResponseFilter(String defaultCharacterEncoding) {
        this.defaultCharacterEncoding = defaultCharacterEncoding;
    }

    public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
        CharsetHolder firstSupportedCharset;
        String acceptCharsetHeaderValue = request.getHeaderValue("Accept-Charset");
        if (acceptCharsetHeaderValue == null || acceptCharsetHeaderValue.isEmpty()) {
            acceptCharsetHeaderValue = this.defaultCharacterEncoding;
        }
        if ((firstSupportedCharset = CharsetHolder.getFirstSupportedCharset(acceptCharsetHeaderValue)) != null) {
            MediaType contentTypeSpecifiedByService = response.getMediaType();
            if (contentTypeSpecifiedByService != null && !contentTypeSpecifiedByService.getParameters().containsKey(CHARSET)) {
                MediaType mediaTypeWithCharset = new MediaType(contentTypeSpecifiedByService.getType(), contentTypeSpecifiedByService.getSubtype(), Collections.singletonMap(CHARSET, firstSupportedCharset.getCharset()));
                response.getHttpHeaders().putSingle((Object)CONTENT_TYPE, (Object)mediaTypeWithCharset);
            }
        } else {
            response.setStatus(Response.Status.NOT_ACCEPTABLE.getStatusCode());
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("message", "[" + firstSupportedCharset.getCharset() + "] is not a valid character set or is not supported by Rexster.  Check the Accept-Charset of the request and the <character-set> setting in rexster.xml");
            JSONObject jsonError = new JSONObject(m);
            response.setEntity((Object)jsonError);
        }
        response.getHttpHeaders().putSingle((Object)HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, (Object)"*");
        return response;
    }
}

