/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.server;

import com.tinkerpop.rexster.RexsterApplicationGraph;
import com.tinkerpop.rexster.config.GraphConfigurationContainer;
import com.tinkerpop.rexster.config.GraphConfigurationException;
import com.tinkerpop.rexster.server.AbstractMapRexsterApplication;
import com.tinkerpop.rexster.server.RexsterProperties;
import com.tinkerpop.rexster.util.HierarchicalConfigurationComparator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;

public class XmlRexsterApplication
extends AbstractMapRexsterApplication {
    private static final Logger logger = Logger.getLogger(XmlRexsterApplication.class);
    private static final HierarchicalConfigurationComparator configComparator = new HierarchicalConfigurationComparator();
    private List<HierarchicalConfiguration> previousConfigurations;

    public XmlRexsterApplication(List<HierarchicalConfiguration> graphConfigs) {
        this.reconfigure(graphConfigs);
    }

    public XmlRexsterApplication(final RexsterProperties properties) {
        properties.addListener(new RexsterProperties.RexsterPropertiesListener(){

            @Override
            public void propertiesChanged(XMLConfiguration configuration) {
                XmlRexsterApplication.this.reconfigure(properties.getGraphConfigurations());
            }
        });
        this.reconfigure(properties.getGraphConfigurations());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void reconfigure(List<HierarchicalConfiguration> graphConfigs) {
        try {
            ArrayList<Object> graphsToKill = new ArrayList<Object>();
            ArrayList<HierarchicalConfiguration> differentConfigs = new ArrayList<HierarchicalConfiguration>();
            for (HierarchicalConfiguration hierarchicalConfiguration : graphConfigs) {
                HierarchicalConfiguration foundGc = this.find(hierarchicalConfiguration);
                if (foundGc != null && configComparator.compare((Configuration)foundGc, (Configuration)hierarchicalConfiguration)) continue;
                differentConfigs.add(hierarchicalConfiguration);
                RexsterApplicationGraph ragToKill = (RexsterApplicationGraph)this.graphs.get(hierarchicalConfiguration.getString("graph-name"));
                if (ragToKill == null) continue;
                graphsToKill.add(ragToKill);
            }
            for (Map.Entry entry : this.graphs.entrySet()) {
                boolean found = false;
                for (HierarchicalConfiguration gc : graphConfigs) {
                    if (!gc.getString("graph-name").equals(entry.getKey())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                graphsToKill.add(entry.getValue());
            }
            for (RexsterApplicationGraph rexsterApplicationGraph : graphsToKill) {
                try {
                    rexsterApplicationGraph.getUnwrappedGraph().shutdown();
                    this.graphs.remove(rexsterApplicationGraph.getGraphName());
                }
                catch (Exception ex) {
                    try {
                        logger.error((Object)String.format("Error while shutting down graph [%s] after finding it no longer configured.", rexsterApplicationGraph), (Throwable)ex);
                        this.graphs.remove(rexsterApplicationGraph.getGraphName());
                    }
                    catch (Throwable throwable) {
                        this.graphs.remove(rexsterApplicationGraph.getGraphName());
                        Object var5_13 = null;
                        logger.info((Object)String.format("Shutdown graph [%s].  It is no longer configured.", var5_13));
                        throw throwable;
                    }
                    Object var5_12 = null;
                    logger.info((Object)String.format("Shutdown graph [%s].  It is no longer configured.", var5_12));
                    continue;
                }
                Object var5_11 = null;
                logger.info((Object)String.format("Shutdown graph [%s].  It is no longer configured.", var5_11));
            }
            GraphConfigurationContainer container = new GraphConfigurationContainer(differentConfigs);
            Map<String, RexsterApplicationGraph> map = container.getApplicationGraphs();
            this.graphs.putAll(map);
            this.previousConfigurations = graphConfigs;
        }
        catch (GraphConfigurationException gce) {
            logger.error((Object)"Graph initialization failed. Check the graph configuration in rexster.xml.");
        }
    }

    private HierarchicalConfiguration find(HierarchicalConfiguration hcToFind) {
        if (this.previousConfigurations == null) {
            return null;
        }
        for (HierarchicalConfiguration hc : this.previousConfigurations) {
            String nameToFind = hcToFind.getString("graph-name");
            if (!nameToFind.equals(hc.getString("graph-name"))) continue;
            return hc;
        }
        return null;
    }
}

