/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.server.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ganglia.GangliaReporter;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.tinkerpop.rexster.server.RexsterProperties;
import com.tinkerpop.rexster.server.metrics.AbstractReporterConfig;
import com.tinkerpop.rexster.server.metrics.ConsoleReporterConfig;
import com.tinkerpop.rexster.server.metrics.GangliaReporterConfig;
import com.tinkerpop.rexster.server.metrics.GraphiteReporterConfig;
import com.tinkerpop.rexster.server.metrics.HttpReporterConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;

public class ReporterConfig {
    private static final Logger logger = Logger.getLogger(ReporterConfig.class);
    private RexsterProperties properties;
    private JmxReporter jmxReporter = null;
    private HttpReporterConfig httpReporterConfig = null;
    private final MetricRegistry metricRegistry;
    private final List<AbstractReporterConfig> reporters = new ArrayList<AbstractReporterConfig>();

    public ReporterConfig(RexsterProperties properties, MetricRegistry metricRegistry) {
        this.properties = properties;
        this.metricRegistry = metricRegistry;
        this.updateSettings();
        this.enable();
        properties.addListener(new RexsterProperties.RexsterPropertiesListener(){

            @Override
            public void propertiesChanged(XMLConfiguration configuration) {
                ReporterConfig.this.updateSettings();
                ReporterConfig.this.enable();
            }
        });
    }

    public void updateSettings() {
        this.reset();
        for (HierarchicalConfiguration reporterConfig : this.properties.getReporterConfigurations()) {
            String reporterType = reporterConfig.getString("type");
            if (reporterType != null) {
                if (reporterType.equals("jmx") || reporterType.equals(JmxReporter.class.getCanonicalName())) {
                    if (this.jmxReporter != null) continue;
                    this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).build();
                    continue;
                }
                if (reporterType.equals("http")) {
                    if (this.httpReporterConfig != null) continue;
                    this.httpReporterConfig = new HttpReporterConfig(reporterConfig);
                    continue;
                }
                if (reporterType.equals("console") || reporterType.equals(ConsoleReporter.class.getCanonicalName())) {
                    this.reporters.add(new ConsoleReporterConfig(reporterConfig, this.metricRegistry));
                    continue;
                }
                if (reporterType.equals("ganglia") || reporterType.equals(GangliaReporter.class.getCanonicalName())) {
                    this.reporters.add(new GangliaReporterConfig(reporterConfig, this.metricRegistry));
                    continue;
                }
                if (reporterType.equals("graphite") || reporterType.equals(GraphiteReporter.class.getCanonicalName())) {
                    this.reporters.add(new GraphiteReporterConfig(reporterConfig, this.metricRegistry));
                    continue;
                }
                logger.warn((Object)String.format("The configured reporter [%s] is not valid", reporterType));
                continue;
            }
            logger.warn((Object)"A metric reporter was not configured properly.  Check rexster.xml as the 'type' attribute was not set.");
        }
        this.properties.addOverride("http-reporter-enabled", this.isHttpReporterEnabled());
        this.properties.addOverride("http-reporter-duration", this.getDurationTimeUnitConversion());
        this.properties.addOverride("http-reporter-convert", this.getRateTimeUnitConversion());
    }

    private void reset() {
        if (this.jmxReporter != null) {
            this.jmxReporter.stop();
            this.jmxReporter = null;
        }
        for (AbstractReporterConfig reporter : this.reporters) {
            reporter.disable();
        }
        this.reporters.clear();
        if (this.httpReporterConfig != null) {
            this.httpReporterConfig = null;
        }
        this.properties.removeOverride("http-reporter-enabled");
        this.properties.removeOverride("http-reporter-duration");
        this.properties.removeOverride("http-reporter-convert");
    }

    public boolean isHttpReporterEnabled() {
        return this.httpReporterConfig != null;
    }

    public String getRateTimeUnitConversion() {
        return this.isHttpReporterEnabled() ? this.httpReporterConfig.getRealRateTimeUnitConversion().toString() : TimeUnit.SECONDS.toString();
    }

    public String getDurationTimeUnitConversion() {
        return this.isHttpReporterEnabled() ? this.httpReporterConfig.getRealDurationTimeUnitConversion().toString() : TimeUnit.SECONDS.toString();
    }

    public void enable() {
        if (this.jmxReporter != null) {
            this.jmxReporter.start();
        }
        for (AbstractReporterConfig reporter : this.reporters) {
            reporter.enable();
        }
    }
}

