/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.contain;

import java.util.Comparator;
import org.glassfish.pfl.basic.contain.Pair;

public class PairComparator<S, T>
implements Comparator<Pair<S, T>> {
    private Comparator<? super S> sc;
    private Comparator<? super T> tc;

    public PairComparator(Comparator<? super S> sc, Comparator<? super T> tc) {
        if (sc == null || tc == null) {
            throw new IllegalArgumentException();
        }
        this.sc = sc;
        this.tc = tc;
    }

    @Override
    public int compare(Pair<S, T> o1, Pair<S, T> o2) {
        int res = this.sc.compare(o1.first(), o2.first());
        if (res == 0) {
            return this.tc.compare(o1.second(), o2.second());
        }
        return res;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PairComparator)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PairComparator other = (PairComparator)obj;
        return ((Object)other.sc).equals(this.sc) && ((Object)other.tc).equals(this.tc);
    }

    public int hashCode() {
        return this.sc.hashCode() ^ this.tc.hashCode();
    }

    public String toString() {
        return "PairComparator[" + this.sc + "," + this.tc + "]";
    }
}

