/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.renderer;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.util.wrappers.event.EventGraph;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Logger;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.renderer.AbstractGraphRenderer;
import org.jboss.windup.reporting.renderer.GraphWriter;
import org.jboss.windup.reporting.renderer.dot.VizJSHtmlWriter;
import org.jboss.windup.reporting.renderer.gexf.SigmaJSHtmlWriter;
import org.jboss.windup.reporting.renderer.graphlib.DagreD3JSHtmlWriter;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;

public class GraphExporter
extends AbstractGraphRenderer {
    private static final Logger LOG = Logging.get(GraphExporter.class);

    public void renderGraph(GraphContext context) {
        EventGraph graph = context.getGraph();
        WindupConfigurationModel configuration = WindupConfigurationService.getConfigurationModel((GraphContext)context);
        Path vizJSOutFile = this.createOutputFolder(configuration, "visjs").resolve("index.html");
        Path sigmaOutFile = this.createOutputFolder(configuration, "sigma").resolve("index.html");
        Path dagreD3OutFile = this.createOutputFolder(configuration, "dagred3").resolve("index.html");
        this.renderVizjs((Graph)graph, vizJSOutFile.toFile(), "label", "id");
        this.renderSigma((Graph)graph, sigmaOutFile.toFile(), "label", "id");
        this.renderDagreD3((Graph)graph, dagreD3OutFile.toFile(), "label", "id");
    }

    public void renderVizjs(Graph graph, File output, String vertexLabelProperty, String edgeLabel) {
        LOG.fine("Writing Vizjs graph to: " + output.getAbsolutePath());
        this.render(new VizJSHtmlWriter(graph, vertexLabelProperty, edgeLabel), output);
    }

    public void renderSigma(Graph graph, File output, String vertexLabelProperty, String edgeLabel) {
        LOG.fine("Writing Sigmajs graph to: " + output.getAbsolutePath());
        this.render(new SigmaJSHtmlWriter(graph, vertexLabelProperty, edgeLabel), output);
    }

    public void renderDagreD3(Graph graph, File output, String vertexLabelProperty, String edgeLabel) {
        LOG.fine("Writing DagreD3 graph to: " + output.getAbsolutePath());
        this.render(new DagreD3JSHtmlWriter(graph, vertexLabelProperty, edgeLabel), output);
    }

    private void render(GraphWriter writer, File output) {
        try (FileOutputStream fos = new FileOutputStream(output);){
            writer.writeGraph(fos);
        }
        catch (IOException e) {
            throw new WindupException("Failed to render report due to: " + e.getMessage(), (Throwable)e);
        }
    }
}

