/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.core.attribute;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Text implements TitanPredicate
{
    CONTAINS{

        @Override
        public boolean evaluate(Object value, Object condition) {
            this.preevaluate(value, condition);
            if (value == null) {
                return false;
            }
            return this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String term) {
            for (String token : 1.tokenize(value.toLowerCase())) {
                if (!token.equalsIgnoreCase(term.trim())) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            if (condition == null) {
                return false;
            }
            return condition instanceof String && StringUtils.isNotBlank((String)((String)condition));
        }
    }
    ,
    CONTAINS_PREFIX{

        @Override
        public boolean evaluate(Object value, Object condition) {
            this.preevaluate(value, condition);
            if (value == null) {
                return false;
            }
            return this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String prefix) {
            for (String token : 2.tokenize(value.toLowerCase())) {
                if (!PREFIX.evaluateRaw(token, prefix.toLowerCase())) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition != null && condition instanceof String;
        }
    }
    ,
    CONTAINS_REGEX{

        @Override
        public boolean evaluate(Object value, Object condition) {
            this.preevaluate(value, condition);
            if (value == null) {
                return false;
            }
            return this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String regex) {
            for (String token : 3.tokenize(value.toLowerCase())) {
                if (!REGEX.evaluateRaw(token, regex)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition != null && condition instanceof String && StringUtils.isNotBlank((String)condition.toString());
        }
    }
    ,
    PREFIX{

        @Override
        public boolean evaluate(Object value, Object condition) {
            this.preevaluate(value, condition);
            if (value == null) {
                return false;
            }
            return this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String prefix) {
            return value.startsWith(prefix.trim());
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition != null && condition instanceof String;
        }
    }
    ,
    REGEX{

        @Override
        public boolean evaluate(Object value, Object condition) {
            this.preevaluate(value, condition);
            if (value == null) {
                return false;
            }
            return this.evaluateRaw(value.toString(), (String)condition);
        }

        @Override
        public boolean evaluateRaw(String value, String regex) {
            return value.matches(regex);
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition != null && condition instanceof String && StringUtils.isNotBlank((String)condition.toString());
        }
    };

    private static final Logger log;
    private static final int MIN_TOKEN_LENGTH = 1;

    public void preevaluate(Object value, Object condition) {
        Preconditions.checkArgument((boolean)this.isValidCondition(condition), (String)"Invalid condition provided: %s", (Object[])new Object[]{condition});
        if (!(value instanceof String)) {
            log.debug("Value not a string: " + value);
        }
    }

    abstract boolean evaluateRaw(String var1, String var2);

    public static List<String> tokenize(String str) {
        ArrayList<String> tokens = new ArrayList<String>();
        int previous = 0;
        for (int p = 0; p < str.length(); ++p) {
            if (Character.isLetterOrDigit(str.charAt(p))) continue;
            if (p > previous + 1) {
                tokens.add(str.substring(previous, p));
            }
            previous = p + 1;
        }
        if (previous + 1 < str.length()) {
            tokens.add(str.substring(previous, str.length()));
        }
        return tokens;
    }

    @Override
    public boolean isValidValueType(Class<?> clazz) {
        Preconditions.checkNotNull(clazz);
        return clazz.equals(String.class);
    }

    @Override
    public boolean hasNegation() {
        return false;
    }

    @Override
    public TitanPredicate negate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isQNF() {
        return true;
    }

    static {
        log = LoggerFactory.getLogger(Text.class);
    }
}

