/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.blueprints;

import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanGraphQuery;
import com.thinkaurelius.titan.core.TitanIndexQuery;
import com.thinkaurelius.titan.core.TitanMultiVertexQuery;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.graphdb.blueprints.TitanBlueprintsTransaction;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.util.ExceptionFactory;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TitanBlueprintsGraph
implements TitanGraph {
    private static final Logger log = LoggerFactory.getLogger(TitanBlueprintsGraph.class);
    private ThreadLocal<TitanBlueprintsTransaction> txs = new ThreadLocal<TitanBlueprintsTransaction>(){

        @Override
        protected TitanBlueprintsTransaction initialValue() {
            return null;
        }
    };
    private final Map<TitanBlueprintsTransaction, Boolean> openTx = new ConcurrentHashMap<TitanBlueprintsTransaction, Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        TitanTransaction tx = this.txs.get();
        if (tx != null && tx.isOpen()) {
            try {
                tx.commit();
            }
            finally {
                this.txs.remove();
                this.openTx.remove(tx);
                log.debug("Committed thread-bound transaction {}", (Object)tx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        TitanTransaction tx = this.txs.get();
        if (tx != null && tx.isOpen()) {
            try {
                tx.rollback();
            }
            finally {
                this.txs.remove();
                this.openTx.remove(tx);
                log.debug("Rolled back thread-bound transaction {}", (Object)tx);
            }
        }
    }

    @Deprecated
    public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        switch (conclusion) {
            case SUCCESS: {
                this.commit();
                break;
            }
            case FAILURE: {
                this.rollback();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized conclusion: " + conclusion);
            }
        }
    }

    public abstract TitanTransaction newThreadBoundTransaction();

    private TitanBlueprintsTransaction getAutoStartTx() {
        TitanBlueprintsTransaction tx;
        if (this.txs == null) {
            ExceptionFactory.graphShutdown();
        }
        if ((tx = this.txs.get()) == null) {
            tx = (TitanBlueprintsTransaction)this.newThreadBoundTransaction();
            this.txs.set(tx);
            this.openTx.put(tx, Boolean.TRUE);
            log.debug("Created new thread-bound transaction {}", (Object)tx);
        }
        return tx;
    }

    public TitanTransaction getCurrentThreadTx() {
        return this.getAutoStartTx();
    }

    @Override
    public synchronized void shutdown() {
        for (TitanTransaction titanTransaction : this.openTx.keySet()) {
            titanTransaction.commit();
        }
        this.openTx.clear();
        this.txs = null;
    }

    public String toString() {
        GraphDatabaseConfiguration config = ((StandardTitanGraph)this).getConfiguration();
        return "titangraph[" + config.getBackendDescription() + "]";
    }

    public <T extends Element> void dropKeyIndex(String key, Class<T> elementClass) {
        throw new UnsupportedOperationException("Key indexes cannot be dropped");
    }

    public <T extends Element> void createKeyIndex(String key, Class<T> elementClass, Parameter ... indexParameters) {
        this.getAutoStartTx().createKeyIndex(key, elementClass, new Parameter[0]);
    }

    public <T extends Element> Set<String> getIndexedKeys(Class<T> elementClass) {
        return this.getAutoStartTx().getIndexedKeys(elementClass);
    }

    public TitanVertex addVertex(Object id) {
        return this.getAutoStartTx().addVertex(id);
    }

    public TitanVertex getVertex(Object id) {
        return this.getAutoStartTx().getVertex(id);
    }

    public void removeVertex(Vertex vertex) {
        this.getAutoStartTx().removeVertex(vertex);
    }

    public Iterable<Vertex> getVertices() {
        return this.getAutoStartTx().getVertices();
    }

    @Override
    public boolean containsRelationType(String name) {
        return this.getAutoStartTx().containsRelationType(name);
    }

    @Override
    public RelationType getRelationType(String name) {
        return this.getAutoStartTx().getRelationType(name);
    }

    @Override
    public boolean containsVertexLabel(String name) {
        return this.getAutoStartTx().containsVertexLabel(name);
    }

    @Override
    public VertexLabel getVertexLabel(String name) {
        return this.getAutoStartTx().getVertexLabel(name);
    }

    @Override
    public TitanVertex addVertexWithLabel(VertexLabel vertexLabel) {
        return this.getAutoStartTx().addVertexWithLabel(vertexLabel);
    }

    @Override
    public TitanVertex addVertexWithLabel(String vertexLabel) {
        return this.getAutoStartTx().addVertexWithLabel(vertexLabel);
    }

    @Override
    public TitanGraphQuery<? extends TitanGraphQuery> query() {
        return this.getAutoStartTx().query();
    }

    @Override
    public TitanIndexQuery indexQuery(String indexName, String query) {
        return this.getAutoStartTx().indexQuery(indexName, query);
    }

    @Override
    public TitanMultiVertexQuery multiQuery(TitanVertex ... vertices) {
        return this.getAutoStartTx().multiQuery(vertices);
    }

    @Override
    public TitanMultiVertexQuery multiQuery(Collection<TitanVertex> vertices) {
        return this.getAutoStartTx().multiQuery(vertices);
    }

    public Iterable<Vertex> getVertices(String key, Object value) {
        return this.getAutoStartTx().getVertices(key, value);
    }

    public TitanEdge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        return this.getAutoStartTx().addEdge(id, outVertex, inVertex, label);
    }

    public TitanEdge getEdge(Object id) {
        return this.getAutoStartTx().getEdge(id);
    }

    public void removeEdge(Edge edge) {
        this.getAutoStartTx().removeEdge(edge);
    }

    public Iterable<Edge> getEdges() {
        return this.getAutoStartTx().getEdges();
    }

    public Iterable<Edge> getEdges(String key, Object value) {
        return this.getAutoStartTx().getEdges(key, value);
    }
}

