/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.idmanagement;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.graphdb.database.idhandling.VariableLong;
import com.thinkaurelius.titan.graphdb.idmanagement.IDInspector;

public class IDManager {
    public static final int SCHEMA_PARTITION = 0;
    public static final int PARTITIONED_VERTEX_PARTITION = 1;
    public static final int TYPE_LEN_RESERVE = 3;
    private static final long TOTAL_BITS = 63L;
    private static final long MAX_PARTITION_BITS = 16L;
    private static final long DEFAULT_PARTITION_BITS = 0L;
    public static final long USERVERTEX_PADDING_BITWIDTH = VertexIDType.NormalVertex.offset();
    public static final long MAX_PADDING_BITWIDTH = VertexIDType.UserEdgeLabel.offset();
    private static final long SCHEMA_COUNT_BOUND = 1L << (int)(63L - MAX_PADDING_BITWIDTH - 3L);
    private final long partitionBits;
    private final long partitionOffset;
    private final long partitionIDBound;
    private final long relationCountBound;
    private final long vertexCountBound;
    private final IDInspector inspector = new IDInspector(){

        @Override
        public final boolean isSchemaVertexId(long id) {
            return VertexIDType.Schema.is(id);
        }

        @Override
        public final boolean isRelationTypeId(long id) {
            return VertexIDType.RelationType.is(id);
        }

        @Override
        public final boolean isEdgeLabelId(long id) {
            return VertexIDType.EdgeLabel.is(id);
        }

        @Override
        public final boolean isPropertyKeyId(long id) {
            return VertexIDType.PropertyKey.is(id);
        }

        @Override
        public boolean isSystemRelationTypeId(long id) {
            return IDManager.isSystemRelationTypeId(id);
        }

        @Override
        public boolean isGenericSchemaVertexId(long id) {
            return VertexIDType.GenericSchemaType.is(id);
        }

        @Override
        public boolean isVertexLabelVertexId(long id) {
            return VertexIDType.VertexLabel.is(id);
        }

        @Override
        public final boolean isUserVertexId(long id) {
            return IDManager.this.isUserVertex(id);
        }

        @Override
        public boolean isUnmodifiableVertex(long id) {
            return IDManager.this.isUserVertex(id) && VertexIDType.UnmodifiableVertex.is(id);
        }

        @Override
        public boolean isPartitionedVertex(long id) {
            return IDManager.this.isPartitionedVertex(id);
        }

        @Override
        public long getCanonicalVertexId(long partitionedVertexId) {
            return IDManager.this.getCanonicalVertexId(partitionedVertexId);
        }
    };

    public IDManager(long partitionBits) {
        Preconditions.checkArgument((partitionBits >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((partitionBits <= 16L ? 1 : 0) != 0, (String)"Partition bits can be at most %s bits", (Object[])new Object[]{16L});
        this.partitionBits = partitionBits;
        this.partitionIDBound = 1L << (int)partitionBits;
        long l = this.relationCountBound = partitionBits == 0L ? Long.MAX_VALUE : 1L << (int)(63L - partitionBits);
        assert (VertexIDType.NormalVertex.offset() > 0L);
        this.vertexCountBound = 1L << (int)(63L - partitionBits - USERVERTEX_PADDING_BITWIDTH);
        this.partitionOffset = 64L - partitionBits;
    }

    public IDManager() {
        this(0L);
    }

    public long getPartitionBound() {
        return this.partitionIDBound;
    }

    private long constructId(long count, long partition, VertexIDType type) {
        Preconditions.checkArgument((partition < this.partitionIDBound && partition >= 0L ? 1 : 0) != 0, (String)"Invalid partition: %s", (Object[])new Object[]{partition});
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument(((long)VariableLong.unsignedBitLength(count) + this.partitionBits + (type == null ? 0L : type.offset()) <= 63L ? 1 : 0) != 0);
        Preconditions.checkArgument((type == null || type.isProper() ? 1 : 0) != 0);
        long id = (count << (int)this.partitionBits) + partition;
        if (type != null) {
            id = type.addPadding(id);
        }
        return id;
    }

    private static VertexIDType getUserVertexIDType(long vertexid) {
        VertexIDType type = null;
        if (VertexIDType.NormalVertex.is(vertexid)) {
            type = VertexIDType.NormalVertex;
        } else if (VertexIDType.PartitionedVertex.is(vertexid)) {
            type = VertexIDType.PartitionedVertex;
        } else if (VertexIDType.UnmodifiableVertex.is(vertexid)) {
            type = VertexIDType.UnmodifiableVertex;
        }
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Vertex id has unrecognized type: %s", (Object[])new Object[]{vertexid});
        return type;
    }

    private boolean isUserVertex(long vertexid) {
        return VertexIDType.UserVertex.is(vertexid) && vertexid >>> (int)(this.partitionBits + USERVERTEX_PADDING_BITWIDTH) > 0L;
    }

    public long getPartitionId(long vertexid) {
        if (VertexIDType.Schema.is(vertexid)) {
            return 0L;
        }
        assert (this.isUserVertex(vertexid) && IDManager.getUserVertexIDType(vertexid) != null);
        long partition = vertexid >>> (int)USERVERTEX_PADDING_BITWIDTH & this.partitionIDBound - 1L;
        assert (partition >= 0L);
        return partition;
    }

    public StaticBuffer getKey(long vertexid) {
        if (VertexIDType.Schema.is(vertexid)) {
            return BufferUtil.getLongBuffer(vertexid);
        }
        assert (this.isUserVertex(vertexid));
        VertexIDType type = IDManager.getUserVertexIDType(vertexid);
        assert (type.offset() == USERVERTEX_PADDING_BITWIDTH);
        long partition = this.getPartitionId(vertexid);
        long count = vertexid >>> (int)(this.partitionBits + USERVERTEX_PADDING_BITWIDTH);
        assert (count > 0L);
        long keyid = partition << (int)this.partitionOffset | type.addPadding(count);
        return BufferUtil.getLongBuffer(keyid);
    }

    public long getKeyID(StaticBuffer b) {
        long value = b.getLong(0);
        if (VertexIDType.Schema.is(value)) {
            return value;
        }
        VertexIDType type = IDManager.getUserVertexIDType(value);
        long partition = this.partitionOffset < 64L ? value >>> (int)this.partitionOffset : 0L;
        long count = value >>> (int)USERVERTEX_PADDING_BITWIDTH & (1L << (int)(this.partitionOffset - USERVERTEX_PADDING_BITWIDTH)) - 1L;
        return this.constructId(count, partition, type);
    }

    public long getRelationID(long count, long partition) {
        Preconditions.checkArgument((count > 0L && count < this.relationCountBound ? 1 : 0) != 0, (String)"Invalid count for bound: %s", (Object[])new Object[]{this.relationCountBound});
        return this.constructId(count, partition, null);
    }

    public long getVertexID(long count, long partition, VertexIDType vertexType) {
        Preconditions.checkArgument((boolean)VertexIDType.UserVertex.is(vertexType.suffix()), (String)"Not a user vertex type: %s", (Object[])new Object[]{vertexType});
        Preconditions.checkArgument((count > 0L && count < this.vertexCountBound ? 1 : 0) != 0, (String)"Invalid count for bound: %s", (Object[])new Object[]{this.vertexCountBound});
        if (vertexType == VertexIDType.PartitionedVertex) {
            Preconditions.checkArgument((partition == 1L ? 1 : 0) != 0);
            return this.getCanonicalVertexIdFromCount(count);
        }
        return this.constructId(count, partition, vertexType);
    }

    public long getPartitionHashForId(long id) {
        Preconditions.checkArgument((id > 0L ? 1 : 0) != 0);
        Preconditions.checkState((this.partitionBits > 0L ? 1 : 0) != 0, (Object)"no partition bits");
        long result = 0L;
        int offset = 0;
        while (offset < 64) {
            result ^= id >>> offset & this.partitionIDBound - 1L;
            offset = (int)((long)offset + this.partitionBits);
        }
        assert (result >= 0L && result < this.partitionIDBound);
        return result;
    }

    private long getCanonicalVertexIdFromCount(long count) {
        long partition = this.getPartitionHashForId(count);
        return this.constructId(count, partition, VertexIDType.PartitionedVertex);
    }

    public long getCanonicalVertexId(long partitionedVertexId) {
        Preconditions.checkArgument((boolean)VertexIDType.PartitionedVertex.is(partitionedVertexId));
        long count = partitionedVertexId >>> (int)(this.partitionBits + USERVERTEX_PADDING_BITWIDTH);
        return this.getCanonicalVertexIdFromCount(count);
    }

    public boolean isCanonicalVertexId(long partitionVertexId) {
        return partitionVertexId == this.getCanonicalVertexId(partitionVertexId);
    }

    public long getPartitionedVertexId(long partitionedVertexId, long otherPartition) {
        Preconditions.checkArgument((boolean)VertexIDType.PartitionedVertex.is(partitionedVertexId));
        long count = partitionedVertexId >>> (int)(this.partitionBits + USERVERTEX_PADDING_BITWIDTH);
        assert (count > 0L);
        return this.constructId(count, otherPartition, VertexIDType.PartitionedVertex);
    }

    public long[] getPartitionedVertexRepresentatives(long partitionedVertexId) {
        Preconditions.checkArgument((boolean)this.isPartitionedVertex(partitionedVertexId));
        assert (this.getPartitionBound() < Integer.MAX_VALUE);
        long[] ids = new long[(int)this.getPartitionBound()];
        int i = 0;
        while ((long)i < this.getPartitionBound()) {
            ids[i] = this.getPartitionedVertexId(partitionedVertexId, i);
            ++i;
        }
        return ids;
    }

    public boolean isPartitionedVertex(long id) {
        return this.isUserVertex(id) && VertexIDType.PartitionedVertex.is(id);
    }

    public long getRelationCountBound() {
        return this.relationCountBound;
    }

    public long getVertexCountBound() {
        return this.vertexCountBound;
    }

    public static long getTemporaryRelationID(long count) {
        return IDManager.makeTemporary(count);
    }

    public static long getTemporaryVertexID(VertexIDType type, long count) {
        Preconditions.checkArgument((boolean)type.isProper(), (String)"Invalid vertex id type: %s", (Object[])new Object[]{type});
        return IDManager.makeTemporary(type.addPadding(count));
    }

    private static long makeTemporary(long id) {
        Preconditions.checkArgument((id > 0L ? 1 : 0) != 0);
        return Long.MIN_VALUE | id;
    }

    public static boolean isTemporary(long id) {
        return id < 0L;
    }

    private static void checkSchemaTypeId(VertexIDType type, long count) {
        Preconditions.checkArgument((boolean)VertexIDType.Schema.is(type.suffix()), (String)"Expected schema vertex but got: %s", (Object[])new Object[]{type});
        Preconditions.checkArgument((boolean)type.isProper(), (String)"Expected proper type but got: %s", (Object[])new Object[]{type});
        Preconditions.checkArgument((count > 0L && count < SCHEMA_COUNT_BOUND ? 1 : 0) != 0, (String)"Invalid id [%s] for type [%s] bound: %s", (Object[])new Object[]{count, type, SCHEMA_COUNT_BOUND});
    }

    public static long getSchemaId(VertexIDType type, long count) {
        IDManager.checkSchemaTypeId(type, count);
        return type.addPadding(count);
    }

    private static boolean isProperRelationType(long id) {
        return VertexIDType.UserEdgeLabel.is(id) || VertexIDType.SystemEdgeLabel.is(id) || VertexIDType.UserPropertyKey.is(id) || VertexIDType.SystemPropertyKey.is(id);
    }

    public static long stripEntireRelationTypePadding(long id) {
        Preconditions.checkArgument((boolean)IDManager.isProperRelationType(id));
        return VertexIDType.UserEdgeLabel.removePadding(id);
    }

    public static long stripRelationTypePadding(long id) {
        Preconditions.checkArgument((boolean)IDManager.isProperRelationType(id));
        return VertexIDType.RelationType.removePadding(id);
    }

    public static long addRelationTypePadding(long id) {
        long typeid = VertexIDType.RelationType.addPadding(id);
        Preconditions.checkArgument((boolean)IDManager.isProperRelationType(typeid));
        return typeid;
    }

    public static boolean isSystemRelationTypeId(long id) {
        return VertexIDType.SystemEdgeLabel.is(id) || VertexIDType.SystemPropertyKey.is(id);
    }

    public static long getSchemaCountBound() {
        return SCHEMA_COUNT_BOUND;
    }

    public IDInspector getIdInspector() {
        return this.inspector;
    }

    public static abstract class VertexIDType
    extends Enum<VertexIDType> {
        public static final /* enum */ VertexIDType UserVertex = new VertexIDType(){

            @Override
            final long offset() {
                return 1L;
            }

            @Override
            final long suffix() {
                return 0L;
            }

            @Override
            final boolean isProper() {
                return false;
            }
        };
        public static final /* enum */ VertexIDType NormalVertex = new VertexIDType(){

            @Override
            final long offset() {
                return 3L;
            }

            @Override
            final long suffix() {
                return 0L;
            }

            @Override
            final boolean isProper() {
                return true;
            }
        };
        public static final /* enum */ VertexIDType PartitionedVertex = new VertexIDType(){

            @Override
            final long offset() {
                return 3L;
            }

            @Override
            final long suffix() {
                return 2L;
            }

            @Override
            final boolean isProper() {
                return true;
            }
        };
        public static final /* enum */ VertexIDType UnmodifiableVertex = new VertexIDType(){

            @Override
            final long offset() {
                return 3L;
            }

            @Override
            final long suffix() {
                return 4L;
            }

            @Override
            final boolean isProper() {
                return true;
            }
        };
        public static final /* enum */ VertexIDType Hidden = new VertexIDType(){

            @Override
            final long offset() {
                return 1L;
            }

            @Override
            final long suffix() {
                return 1L;
            }

            @Override
            final boolean isProper() {
                return false;
            }
        };
        public static final /* enum */ VertexIDType HiddenVertex = new VertexIDType(){

            @Override
            final long offset() {
                return 2L;
            }

            @Override
            final long suffix() {
                return 3L;
            }

            @Override
            final boolean isProper() {
                return true;
            }
        };
        public static final /* enum */ VertexIDType Schema = new VertexIDType(){

            @Override
            final long offset() {
                return 2L;
            }

            @Override
            final long suffix() {
                return 1L;
            }

            @Override
            final boolean isProper() {
                return false;
            }
        };
        public static final /* enum */ VertexIDType SchemaType = new VertexIDType(){

            @Override
            final long offset() {
                return 3L;
            }

            @Override
            final long suffix() {
                return 5L;
            }

            @Override
            final boolean isProper() {
                return false;
            }
        };
        public static final /* enum */ VertexIDType RelationType = new VertexIDType(){

            @Override
            final long offset() {
                return 4L;
            }

            @Override
            final long suffix() {
                return 5L;
            }

            @Override
            final boolean isProper() {
                return false;
            }
        };
        public static final /* enum */ VertexIDType PropertyKey = new VertexIDType(){

            @Override
            final long offset() {
                return 5L;
            }

            @Override
            final long suffix() {
                return 5L;
            }

            @Override
            final boolean isProper() {
                return false;
            }
        };
        public static final /* enum */ VertexIDType UserPropertyKey = new VertexIDType(){

            @Override
            final long offset() {
                return 6L;
            }

            @Override
            final long suffix() {
                return 5L;
            }

            @Override
            final boolean isProper() {
                return true;
            }
        };
        public static final /* enum */ VertexIDType SystemPropertyKey = new VertexIDType(){

            @Override
            final long offset() {
                return 6L;
            }

            @Override
            final long suffix() {
                return 37L;
            }

            @Override
            final boolean isProper() {
                return true;
            }
        };
        public static final /* enum */ VertexIDType EdgeLabel = new VertexIDType(){

            @Override
            final long offset() {
                return 5L;
            }

            @Override
            final long suffix() {
                return 21L;
            }

            @Override
            final boolean isProper() {
                return false;
            }
        };
        public static final /* enum */ VertexIDType UserEdgeLabel = new VertexIDType(){

            @Override
            final long offset() {
                return 6L;
            }

            @Override
            final long suffix() {
                return 21L;
            }

            @Override
            final boolean isProper() {
                return true;
            }
        };
        public static final /* enum */ VertexIDType SystemEdgeLabel = new VertexIDType(){

            @Override
            final long offset() {
                return 6L;
            }

            @Override
            final long suffix() {
                return 53L;
            }

            @Override
            final boolean isProper() {
                return true;
            }
        };
        public static final /* enum */ VertexIDType VertexLabel = new VertexIDType(){

            @Override
            final long offset() {
                return 5L;
            }

            @Override
            final long suffix() {
                return 13L;
            }

            @Override
            final boolean isProper() {
                return true;
            }
        };
        public static final /* enum */ VertexIDType GenericSchemaType = new VertexIDType(){

            @Override
            final long offset() {
                return 4L;
            }

            @Override
            final long suffix() {
                return 9L;
            }

            @Override
            final boolean isProper() {
                return true;
            }
        };
        private static final /* synthetic */ VertexIDType[] $VALUES;

        public static VertexIDType[] values() {
            return (VertexIDType[])$VALUES.clone();
        }

        public static VertexIDType valueOf(String name) {
            return Enum.valueOf(VertexIDType.class, name);
        }

        abstract long offset();

        abstract long suffix();

        abstract boolean isProper();

        public final long addPadding(long count) {
            assert (this.offset() > 0L);
            Preconditions.checkArgument((count > 0L && count < 1L << (int)(63L - this.offset()) ? 1 : 0) != 0, (String)"Count out of range for type [%s]: %s", (Object[])new Object[]{this, count});
            return count << (int)this.offset() | this.suffix();
        }

        public final long removePadding(long id) {
            return id >>> (int)this.offset();
        }

        public final boolean is(long id) {
            return (id & (1L << (int)this.offset()) - 1L) == this.suffix();
        }

        public final boolean isSubType(VertexIDType type) {
            return this.is(type.suffix());
        }

        static {
            $VALUES = new VertexIDType[]{UserVertex, NormalVertex, PartitionedVertex, UnmodifiableVertex, Hidden, HiddenVertex, Schema, SchemaType, RelationType, PropertyKey, UserPropertyKey, SystemPropertyKey, EdgeLabel, UserEdgeLabel, SystemEdgeLabel, VertexLabel, GenericSchemaType};
        }
    }
}

