/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.internal;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.aesh.cl.activation.NullActivator;
import org.jboss.aesh.cl.activation.OptionActivator;
import org.jboss.aesh.cl.completer.BooleanOptionCompleter;
import org.jboss.aesh.cl.completer.FileOptionCompleter;
import org.jboss.aesh.cl.completer.NullOptionCompleter;
import org.jboss.aesh.cl.completer.OptionCompleter;
import org.jboss.aesh.cl.converter.CLConverterManager;
import org.jboss.aesh.cl.converter.Converter;
import org.jboss.aesh.cl.converter.NullConverter;
import org.jboss.aesh.cl.exception.OptionParserException;
import org.jboss.aesh.cl.internal.OptionType;
import org.jboss.aesh.cl.renderer.NullOptionRenderer;
import org.jboss.aesh.cl.renderer.OptionRenderer;
import org.jboss.aesh.cl.validator.NullValidator;
import org.jboss.aesh.cl.validator.OptionValidator;
import org.jboss.aesh.cl.validator.OptionValidatorException;
import org.jboss.aesh.console.AeshContext;
import org.jboss.aesh.console.InvocationProviders;
import org.jboss.aesh.console.command.converter.AeshConverterInvocation;
import org.jboss.aesh.console.command.validator.AeshValidatorInvocation;
import org.jboss.aesh.io.Resource;
import org.jboss.aesh.terminal.TerminalString;
import org.jboss.aesh.util.ANSI;
import org.jboss.aesh.util.ReflectionUtil;

public final class ProcessedOption {
    private String shortName;
    private String name;
    private String description;
    private List<String> values;
    private String argument;
    private List<String> defaultValues;
    private Class<?> type;
    private Converter converter;
    private OptionType optionType;
    private boolean required = false;
    private char valueSeparator;
    private String fieldName;
    private OptionCompleter completer;
    private Map<String, String> properties;
    private boolean longNameUsed = true;
    private OptionValidator validator;
    private boolean endsWithSeparator = false;
    private OptionActivator activator;
    private OptionRenderer renderer;
    private boolean overrideRequired = false;

    public ProcessedOption(char shortName, String name, String description, String argument, boolean required, char valueSeparator, List<String> defaultValue, Class<?> type, String fieldName, OptionType optionType, Converter converter, OptionCompleter completer, OptionValidator optionValidator, OptionActivator activator, OptionRenderer renderer, boolean overrideRequired) throws OptionParserException {
        this(shortName, name, description, argument, required, valueSeparator, defaultValue, type, fieldName, optionType, null, null, null, null, null);
        this.converter = converter;
        this.completer = completer;
        this.validator = optionValidator;
        this.activator = activator;
        if (this.validator == null) {
            this.validator = new NullValidator();
        }
        if (this.activator == null) {
            this.activator = new NullActivator();
        }
        if (renderer != null) {
            this.renderer = renderer;
        }
    }

    public ProcessedOption(char shortName, String name, String description, String argument, boolean required, char valueSeparator, String[] defaultValue, Class<?> type, String fieldName, OptionType optionType, Class<? extends Converter> converter, Class<? extends OptionCompleter> completer, Class<? extends OptionValidator> optionValidator, Class<? extends OptionActivator> activator, Class<? extends OptionRenderer> renderer) throws OptionParserException {
        this(shortName, name, description, argument, required, valueSeparator, Arrays.asList(defaultValue), type, fieldName, optionType, converter, completer, optionValidator, activator, renderer);
    }

    public ProcessedOption(char shortName, String name, String description, String argument, boolean required, char valueSeparator, List<String> defaultValue, Class<?> type, String fieldName, OptionType optionType, Class<? extends Converter> converter, Class<? extends OptionCompleter> completer, Class<? extends OptionValidator> optionValidator, Class<? extends OptionActivator> optionActivator, Class<? extends OptionRenderer> optionRenderer, boolean overrideRequired) throws OptionParserException {
        this(shortName, name, description, argument, required, valueSeparator, defaultValue, type, fieldName, optionType, converter, completer, optionValidator, optionActivator, optionRenderer);
        this.overrideRequired = overrideRequired;
    }

    public ProcessedOption(char shortName, String name, String description, String argument, boolean required, char valueSeparator, List<String> defaultValue, Class<?> type, String fieldName, OptionType optionType, Class<? extends Converter> converter, Class<? extends OptionCompleter> completer, Class<? extends OptionValidator> optionValidator, Class<? extends OptionActivator> optionActivator, Class<? extends OptionRenderer> optionRenderer) throws OptionParserException {
        if (shortName != '\u0000') {
            this.shortName = String.valueOf(shortName);
        }
        this.name = name;
        this.description = description;
        this.argument = argument;
        this.required = required;
        this.valueSeparator = valueSeparator;
        this.type = type;
        this.fieldName = fieldName;
        this.optionType = optionType;
        this.converter = this.initConverter(converter);
        this.completer = this.initCompleter(completer);
        this.validator = this.initValidator(optionValidator);
        this.activator = this.initActivator(optionActivator);
        this.renderer = this.initRenderer(optionRenderer);
        this.defaultValues = new ArrayList<String>();
        if (defaultValue != null) {
            this.defaultValues.addAll(defaultValue);
        }
        this.properties = new HashMap<String, String>();
        this.values = new ArrayList<String>();
        if (shortName == '\u0000' && name.equals("") && optionType != OptionType.ARGUMENT) {
            throw new OptionParserException("Either shortName or name must be set.");
        }
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getName() {
        return this.name;
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public String getValue() {
        if (this.values.size() > 0) {
            return this.values.get(0);
        }
        return null;
    }

    public List<String> getValues() {
        return this.values;
    }

    public boolean hasValue() {
        return this.optionType != OptionType.BOOLEAN;
    }

    public boolean hasMultipleValues() {
        return this.optionType == OptionType.LIST || this.optionType == OptionType.ARGUMENT;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean doOverrideRequired() {
        return this.overrideRequired;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public char getValueSeparator() {
        return this.valueSeparator;
    }

    public boolean isProperty() {
        return this.optionType == OptionType.GROUP;
    }

    public String getArgument() {
        return this.argument;
    }

    public List<String> getDefaultValues() {
        return this.defaultValues;
    }

    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public OptionType getOptionType() {
        return this.optionType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public OptionCompleter getCompleter() {
        return this.completer;
    }

    public OptionValidator getValidator() {
        return this.validator;
    }

    public OptionActivator getActivator() {
        return this.activator;
    }

    public OptionRenderer getRenderer() {
        return this.renderer;
    }

    public boolean isLongNameUsed() {
        return this.longNameUsed;
    }

    public void setLongNameUsed(boolean longNameUsed) {
        this.longNameUsed = longNameUsed;
    }

    public void setEndsWithSeparator(boolean endsWithSeparator) {
        this.endsWithSeparator = endsWithSeparator;
    }

    public boolean getEndsWithSeparator() {
        return this.endsWithSeparator;
    }

    public void clear() {
        if (this.values != null) {
            this.values.clear();
        }
        if (this.properties != null) {
            this.properties.clear();
        }
        this.longNameUsed = true;
        this.endsWithSeparator = false;
    }

    public String getDisplayName() {
        if (this.isLongNameUsed() && this.name != null) {
            return "--" + this.name;
        }
        if (this.shortName != null) {
            return "-" + this.shortName;
        }
        return null;
    }

    public TerminalString getRenderedNameWithDashes() {
        if (this.renderer == null) {
            return new TerminalString("--" + this.name, true);
        }
        return new TerminalString("--" + this.name, this.renderer.getColor(), this.renderer.getTextType());
    }

    public int getFormattedLength() {
        StringBuilder sb = new StringBuilder();
        if (this.shortName != null) {
            sb.append("-").append(this.shortName);
        }
        if (this.name != null) {
            if (sb.toString().trim().length() > 0) {
                sb.append(", ");
            }
            sb.append("--").append(this.name);
        }
        if (this.argument != null && this.argument.length() > 0) {
            sb.append("=<").append(this.argument).append(">");
        }
        return sb.length();
    }

    public String getFormattedOption(int offset, int descriptionStart, int width) {
        StringBuilder sb = new StringBuilder();
        if (this.required) {
            sb.append(ANSI.getBold());
        }
        if (offset > 0) {
            sb.append(String.format("%" + offset + "s", ""));
        }
        if (this.shortName != null) {
            sb.append("-").append(this.shortName);
        }
        if (this.name != null) {
            if (this.shortName != null) {
                sb.append(", ");
            }
            sb.append("--").append(this.name);
        }
        if (this.argument != null && this.argument.length() > 0) {
            sb.append("=<").append(this.argument).append(">");
        }
        if (this.required) {
            sb.append(ANSI.getBoldOff());
        }
        if (this.description != null && this.description.length() > 0) {
            int descOffset = descriptionStart - this.getFormattedLength() - offset;
            if (descOffset > 0) {
                sb.append(String.format("%" + descOffset + "s", ""));
            } else {
                sb.append(" ");
            }
            sb.append(this.description);
        }
        return sb.toString();
    }

    private Converter initConverter(Class<? extends Converter> converterClass) {
        if (converterClass != null && !converterClass.equals(NullConverter.class)) {
            if (CLConverterManager.getInstance().hasConverter(converterClass)) {
                return CLConverterManager.getInstance().getConverter(converterClass);
            }
            return ReflectionUtil.newInstance(converterClass);
        }
        return CLConverterManager.getInstance().getConverter(this.type);
    }

    private OptionCompleter initCompleter(Class<? extends OptionCompleter> completerClass) {
        if (completerClass != null && !completerClass.equals(NullOptionCompleter.class)) {
            return ReflectionUtil.newInstance(completerClass);
        }
        try {
            if (this.type == Boolean.class || this.type == Boolean.TYPE) {
                return (OptionCompleter)BooleanOptionCompleter.class.newInstance();
            }
            if (this.type == File.class || this.type == Resource.class) {
                return (OptionCompleter)FileOptionCompleter.class.newInstance();
            }
            return null;
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private OptionActivator initActivator(Class<? extends OptionActivator> activator) {
        if (activator != null && activator != NullActivator.class) {
            return ReflectionUtil.newInstance(activator);
        }
        return new NullActivator();
    }

    private OptionValidator initValidator(Class<? extends OptionValidator> validator) {
        if (validator != null && validator != NullValidator.class) {
            return ReflectionUtil.newInstance(validator);
        }
        return new NullValidator();
    }

    private OptionRenderer initRenderer(Class<? extends OptionRenderer> renderer) {
        if (renderer != null && renderer != NullOptionRenderer.class) {
            return ReflectionUtil.newInstance(renderer);
        }
        return null;
    }

    private Object doConvert(String inputValue, InvocationProviders invocationProviders, Object command, AeshContext aeshContext, boolean doValidation) throws OptionValidatorException {
        Object result = this.converter.convert(invocationProviders.getConverterProvider().enhanceConverterInvocation(new AeshConverterInvocation(inputValue, aeshContext)));
        if (this.validator != null && doValidation) {
            this.validator.validate(invocationProviders.getValidatorProvider().enhanceValidatorInvocation(new AeshValidatorInvocation<Object>(result, command, aeshContext)));
        }
        return result;
    }

    public void injectValueIntoField(Object instance, InvocationProviders invocationProviders, AeshContext aeshContext, boolean doValidation) throws OptionValidatorException {
        block32: {
            if (this.converter == null) {
                return;
            }
            try {
                Constructor<?> constructor;
                Field field = instance.getClass().getDeclaredField(this.fieldName);
                if (!Modifier.isPublic(field.getModifiers())) {
                    field.setAccessible(true);
                }
                if (!Modifier.isPublic(instance.getClass().getModifiers()) && (constructor = instance.getClass().getDeclaredConstructor(new Class[0])) != null) {
                    constructor.setAccessible(true);
                }
                if (this.optionType == OptionType.NORMAL || this.optionType == OptionType.BOOLEAN) {
                    if (this.getValue() != null) {
                        field.set(instance, this.doConvert(this.getValue(), invocationProviders, instance, aeshContext, doValidation));
                    } else if (this.defaultValues.size() > 0) {
                        field.set(instance, this.doConvert(this.defaultValues.get(0), invocationProviders, instance, aeshContext, doValidation));
                    }
                    break block32;
                }
                if (this.optionType == OptionType.LIST || this.optionType == OptionType.ARGUMENT) {
                    if (field.getType().isInterface() || Modifier.isAbstract(field.getType().getModifiers())) {
                        if (Set.class.isAssignableFrom(field.getType())) {
                            HashSet<Object> tmpSet = new HashSet<Object>();
                            if (this.values.size() > 0) {
                                for (String in : this.values) {
                                    tmpSet.add(this.doConvert(in, invocationProviders, instance, aeshContext, doValidation));
                                }
                            } else if (this.defaultValues.size() > 0) {
                                for (String in : this.defaultValues) {
                                    tmpSet.add(this.doConvert(in, invocationProviders, instance, aeshContext, doValidation));
                                }
                            }
                            field.set(instance, tmpSet);
                            break block32;
                        }
                        if (!List.class.isAssignableFrom(field.getType())) break block32;
                        ArrayList<Object> tmpList = new ArrayList<Object>();
                        if (this.values.size() > 0) {
                            for (String in : this.values) {
                                tmpList.add(this.doConvert(in, invocationProviders, instance, aeshContext, doValidation));
                            }
                        } else if (this.defaultValues.size() > 0) {
                            for (String in : this.defaultValues) {
                                tmpList.add(this.doConvert(in, invocationProviders, instance, aeshContext, doValidation));
                            }
                        }
                        field.set(instance, tmpList);
                        break block32;
                    }
                    Collection tmpInstance = (Collection)field.getType().newInstance();
                    if (this.values.size() > 0) {
                        for (String in : this.values) {
                            tmpInstance.add(this.doConvert(in, invocationProviders, instance, aeshContext, doValidation));
                        }
                    } else if (this.defaultValues.size() > 0) {
                        for (String in : this.defaultValues) {
                            tmpInstance.add(this.doConvert(in, invocationProviders, instance, aeshContext, doValidation));
                        }
                    }
                    field.set(instance, tmpInstance);
                    break block32;
                }
                if (this.optionType == OptionType.GROUP) {
                    Map tmpMap;
                    if (field.getType().isInterface() || Modifier.isAbstract(field.getType().getModifiers())) {
                        tmpMap = this.newHashMap();
                        for (String propertyKey : this.properties.keySet()) {
                            tmpMap.put(propertyKey, this.doConvert(this.properties.get(propertyKey), invocationProviders, instance, aeshContext, doValidation));
                        }
                        field.set(instance, tmpMap);
                    } else {
                        tmpMap = (Map)field.getType().newInstance();
                        for (String propertyKey : this.properties.keySet()) {
                            tmpMap.put(propertyKey, this.doConvert(this.properties.get(propertyKey), invocationProviders, instance, aeshContext, doValidation));
                        }
                        field.set(instance, tmpMap);
                    }
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }

    public void processAfterInit(InvocationProviders invocationProviders) {
        this.activator = invocationProviders.getOptionActivatorProvider().enhanceOptionActivator(this.activator);
    }

    private <String, T> Map<String, T> newHashMap() {
        return new HashMap();
    }

    public String toString() {
        return "ProcessedOption{shortName='" + this.shortName + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", values=" + this.values + ", defaultValues=" + this.defaultValues + ", argument='" + this.argument + '\'' + ", type=" + this.type + ", required=" + this.required + ", valueSeparator=" + this.valueSeparator + ", properties=" + this.properties + '}';
    }
}

