/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.parser;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Map;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.cl.OptionGroup;
import org.jboss.aesh.cl.OptionList;
import org.jboss.aesh.cl.exception.CommandLineParserException;
import org.jboss.aesh.cl.internal.OptionType;
import org.jboss.aesh.cl.internal.ProcessedCommand;
import org.jboss.aesh.cl.internal.ProcessedOption;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.aesh.cl.parser.CommandLineParserBuilder;
import org.jboss.aesh.cl.validator.OptionValidatorException;
import org.jboss.aesh.console.AeshInvocationProviders;
import org.jboss.aesh.console.command.activator.AeshOptionActivatorProvider;
import org.jboss.aesh.console.command.completer.AeshCompleterInvocationProvider;
import org.jboss.aesh.console.command.converter.AeshConverterInvocationProvider;
import org.jboss.aesh.console.command.validator.AeshValidatorInvocationProvider;

public class ParserGenerator {
    public static CommandLineParser generateCommandLineParser(Object paramInstance) throws CommandLineParserException {
        return ParserGenerator.generateCommandLineParser(paramInstance.getClass());
    }

    public static CommandLineParser generateCommandLineParser(Class clazz) throws CommandLineParserException {
        CommandDefinition command = clazz.getAnnotation(CommandDefinition.class);
        if (command == null) {
            throw new CommandLineParserException("Commands must be annotated with @CommandDefinition");
        }
        ProcessedCommand processedCommand = new ProcessedCommand(command.name(), command.description(), command.validator(), command.resultHandler());
        for (Field field : clazz.getDeclaredFields()) {
            ParameterizedType listType;
            Class type;
            Option o = field.getAnnotation(Option.class);
            if (o != null) {
                OptionType optionType = o.hasValue() ? OptionType.NORMAL : OptionType.BOOLEAN;
                if (o.name() == null || o.name().length() < 1) {
                    processedCommand.addOption(o.shortName(), field.getName(), o.description(), o.argument(), o.required(), ',', o.defaultValue(), field.getType(), field.getName(), optionType, o.converter(), o.completer(), o.validator(), o.activator(), o.renderer(), o.overrideRequired());
                    continue;
                }
                processedCommand.addOption(o.shortName(), o.name(), o.description(), o.argument(), o.required(), ',', o.defaultValue(), field.getType(), field.getName(), optionType, o.converter(), o.completer(), o.validator(), o.activator(), o.renderer(), o.overrideRequired());
                continue;
            }
            OptionList ol = field.getAnnotation(OptionList.class);
            if (ol != null) {
                if (!Collection.class.isAssignableFrom(field.getType())) {
                    throw new CommandLineParserException("OptionGroup field must be instance of Collection");
                }
                type = Object.class;
                if (field.getGenericType() != null) {
                    listType = (ParameterizedType)field.getGenericType();
                    type = (Class)listType.getActualTypeArguments()[0];
                }
                if (ol.name() == null || ol.name().length() < 1) {
                    processedCommand.addOption(ol.shortName(), field.getName(), ol.description(), "", ol.required(), ol.valueSeparator(), ol.defaultValue(), type, field.getName(), OptionType.LIST, ol.converter(), ol.completer(), ol.validator(), ol.activator(), ol.renderer());
                    continue;
                }
                processedCommand.addOption(ol.shortName(), ol.name(), ol.description(), "", ol.required(), ol.valueSeparator(), ol.defaultValue(), type, field.getName(), OptionType.LIST, ol.converter(), ol.completer(), ol.validator(), ol.activator(), ol.renderer());
                continue;
            }
            OptionGroup og = field.getAnnotation(OptionGroup.class);
            if (og != null) {
                if (!Map.class.isAssignableFrom(field.getType())) {
                    throw new CommandLineParserException("OptionGroup field must be instance of Map");
                }
                type = Object.class;
                if (field.getGenericType() != null) {
                    listType = (ParameterizedType)field.getGenericType();
                    type = (Class)listType.getActualTypeArguments()[1];
                }
                if (og.name() == null || og.name().length() < 1) {
                    processedCommand.addOption(og.shortName(), field.getName(), og.description(), "", og.required(), ',', og.defaultValue(), type, field.getName(), OptionType.GROUP, og.converter(), og.completer(), og.validator(), og.activator(), og.renderer());
                    continue;
                }
                processedCommand.addOption(og.shortName(), og.name(), og.description(), "", og.required(), ',', og.defaultValue(), type, field.getName(), OptionType.GROUP, og.converter(), og.completer(), og.validator(), og.activator(), og.renderer());
                continue;
            }
            Arguments a = field.getAnnotation(Arguments.class);
            if (a == null) continue;
            if (!Collection.class.isAssignableFrom(field.getType())) {
                throw new CommandLineParserException("Arguments field must be instance of Collection");
            }
            type = Object.class;
            if (field.getGenericType() != null) {
                listType = (ParameterizedType)field.getGenericType();
                type = (Class)listType.getActualTypeArguments()[0];
            }
            processedCommand.setArgument(new ProcessedOption('\u0000', "", a.description(), "", false, a.valueSeparator(), a.defaultValue(), type, field.getName(), OptionType.ARGUMENT, a.converter(), a.completer(), a.validator(), null, null));
        }
        return new CommandLineParserBuilder().parameter(processedCommand).generateParser();
    }

    public static void parseAndPopulate(Object instance, String input) throws CommandLineParserException, OptionValidatorException {
        CommandLineParser cl = ParserGenerator.generateCommandLineParser(instance.getClass());
        AeshInvocationProviders invocationProviders = new AeshInvocationProviders(new AeshConverterInvocationProvider(), new AeshCompleterInvocationProvider(), new AeshValidatorInvocationProvider(), new AeshOptionActivatorProvider());
        cl.getCommandPopulator().populateObject(instance, cl.parse(input), invocationProviders, null, true);
    }
}

