/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.graphics;

import java.io.IOException;
import org.jboss.aesh.graphics.Graphics;
import org.jboss.aesh.graphics.GraphicsConfiguration;
import org.jboss.aesh.terminal.Color;
import org.jboss.aesh.terminal.CursorPosition;
import org.jboss.aesh.terminal.Shell;
import org.jboss.aesh.terminal.TerminalColor;
import org.jboss.aesh.terminal.TerminalSize;
import org.jboss.aesh.terminal.TerminalTextStyle;
import org.jboss.aesh.util.ANSI;

public class AeshGraphics
implements Graphics {
    private static final String CURSOR_DOWN = ANSI.getStart() + "1B" + ANSI.getStart() + "1D";
    private final Shell shell;
    private final GraphicsConfiguration graphicsConfiguration;
    private TerminalColor currentColor;
    private TerminalTextStyle currentStyle;

    AeshGraphics(Shell shell, GraphicsConfiguration graphicsConfiguration) {
        this.shell = shell;
        this.graphicsConfiguration = graphicsConfiguration;
        this.currentColor = new TerminalColor();
        shell.out().print(ANSI.hideCursor());
    }

    @Override
    public void flush() {
        this.shell.out().flush();
    }

    @Override
    public void clear() {
        try {
            this.shell.out().println(new TerminalColor(Color.DEFAULT, Color.DEFAULT).fullString());
            this.shell.clear();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void cleanup() {
        this.shell.out().print(new TerminalColor(Color.DEFAULT, Color.DEFAULT).fullString());
        this.shell.out().print(ANSI.showCursor());
        this.shell.out().flush();
    }

    @Override
    public TerminalColor getColor() {
        return this.currentColor;
    }

    @Override
    public void setColor(TerminalColor color) {
        this.currentColor = color;
    }

    @Override
    public TerminalTextStyle getTextStyle() {
        return this.currentStyle;
    }

    @Override
    public void setTextStyle(TerminalTextStyle textStyle) {
        this.currentStyle = textStyle;
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        if (this.currentColor != null) {
            this.shell.out().print(this.currentColor.fullString());
        }
        this.drawHorizontalLine(x, y, width);
        this.drawHorizontalLine(x, y + height, width);
        this.drawVerticalLine(x, y + 1, height - 1);
        this.drawVerticalLine(x + width - 1, y + 1, height - 1);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.currentColor != null) {
            this.shell.out().print(this.currentColor.fullString());
        }
        int dx = x2 - x1;
        int dy = y2 - y1;
        int y = 0;
        for (int i = x1; i < x2; ++i) {
            y = y1 + dy * (i - x1) / dx;
            this.shell.setCursor(new CursorPosition(y, i));
            this.shell.out().print('x');
        }
    }

    @Override
    public void drawString(String str, int x, int y) {
        if (this.currentColor != null) {
            this.shell.out().print(this.currentColor.fullString());
        }
        this.shell.setCursor(new CursorPosition(y, x));
        this.shell.out().print(str);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        if (this.currentColor != null) {
            this.shell.out().print(this.currentColor.fullString());
        }
        for (int j = 0; j < height; ++j) {
            this.shell.setCursor(new CursorPosition(y + j, x));
            for (int i = 0; i < width; ++i) {
                this.shell.out().print(' ');
            }
        }
    }

    @Override
    public void drawCircle(int x0, int y0, int radius) {
        if (this.currentColor != null) {
            this.shell.out().print(this.currentColor.fullString());
        }
        int x = radius;
        int radiusError = 1 - x;
        for (int y = 0; x >= y; ++y) {
            this.drawPixel(x + x0, y + y0);
            this.drawPixel(y + x0, x + y0);
            this.drawPixel(-x + x0, y + y0);
            this.drawPixel(-y + x0, x + y0);
            this.drawPixel(-x + x0, -y + y0);
            this.drawPixel(-y + x0, -x + y0);
            this.drawPixel(x + x0, -y + y0);
            this.drawPixel(y + x0, -x + y0);
            if (radiusError < 0) {
                radiusError += 2 * y + 1;
                continue;
            }
            radiusError += 2 * (y - --x + 1);
        }
    }

    private void drawPixel(int x, int y) {
        this.shell.setCursor(new CursorPosition(y, x));
        this.shell.out().print('x');
    }

    private void drawHorizontalLine(int x, int y, int width) {
        TerminalSize terminalSize = this.graphicsConfiguration.getBounds();
        if (terminalSize.getHeight() > y && terminalSize.getWidth() > y) {
            if (terminalSize.getWidth() < x + width) {
                width = terminalSize.getWidth() - x - 1;
            }
            this.shell.setCursor(new CursorPosition(y, x));
            char[] line = new char[width];
            for (int i = 0; i < line.length; ++i) {
                line[i] = i == 0 || i == line.length - 1 ? 120 : 45;
            }
            this.shell.out().print(line);
        }
    }

    private void drawVerticalLine(int x, int y, int length) {
        TerminalSize terminalSize = this.graphicsConfiguration.getBounds();
        if (terminalSize.getHeight() > y && terminalSize.getWidth() > y) {
            if (terminalSize.getHeight() < y + length) {
                length = terminalSize.getHeight() - y - 1;
            }
            this.shell.setCursor(new CursorPosition(y, x));
            for (int i = 0; i < length; ++i) {
                this.shell.out().print('|');
                this.shell.out().print(CURSOR_DOWN);
            }
        }
    }
}

