/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.nio.AbstractNIOConnectionDistributor;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.SelectorRunner;

public final class RoundRobinConnectionDistributor
extends AbstractNIOConnectionDistributor {
    private final AtomicInteger counter = new AtomicInteger();

    public RoundRobinConnectionDistributor(NIOTransport transport) {
        super(transport);
    }

    @Override
    public void registerChannel(SelectableChannel channel, int interestOps, Object attachment) throws IOException {
        SelectorRunner runner = this.getSelectorRunner();
        this.transport.getSelectorHandler().registerChannel(runner, channel, interestOps, attachment);
    }

    @Override
    public void registerChannelAsync(SelectableChannel channel, int interestOps, Object attachment, CompletionHandler<RegisterChannelResult> completionHandler) {
        SelectorRunner runner = this.getSelectorRunner();
        this.transport.getSelectorHandler().registerChannelAsync(runner, channel, interestOps, attachment, completionHandler);
    }

    private SelectorRunner getSelectorRunner() {
        SelectorRunner[] runners = this.getTransportSelectorRunners();
        int index = (this.counter.getAndIncrement() & Integer.MAX_VALUE) % runners.length;
        return runners[index];
    }
}

