/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.DepthFirstAstVisitor;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.transforms.IAstTransform;

public abstract class ContextTrackingVisitor<TResult>
extends DepthFirstAstVisitor<Void, TResult>
implements IAstTransform {
    protected final DecompilerContext context;

    protected ContextTrackingVisitor(DecompilerContext context) {
        this.context = (DecompilerContext)((Object)VerifyArgument.notNull((Object)((Object)context), (String)"context"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TResult visitTypeDeclaration(TypeDeclaration typeDeclaration, Void _) {
        TypeDefinition oldType = this.context.getCurrentType();
        MethodDefinition oldMethod = this.context.getCurrentMethod();
        try {
            this.context.setCurrentType(typeDeclaration.getUserData(Keys.TYPE_DEFINITION));
            this.context.setCurrentMethod(null);
            Object s = super.visitTypeDeclaration(typeDeclaration, _);
            return (TResult)s;
        }
        finally {
            this.context.setCurrentType(oldType);
            this.context.setCurrentMethod(oldMethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TResult visitMethodDeclaration(MethodDeclaration node, Void _) {
        assert (this.context.getCurrentMethod() == null);
        try {
            this.context.setCurrentMethod(node.getUserData(Keys.METHOD_DEFINITION));
            Object s = super.visitMethodDeclaration(node, _);
            return (TResult)s;
        }
        finally {
            this.context.setCurrentMethod(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TResult visitConstructorDeclaration(ConstructorDeclaration node, Void _) {
        assert (this.context.getCurrentMethod() == null);
        try {
            this.context.setCurrentMethod(node.getUserData(Keys.METHOD_DEFINITION));
            Object s = super.visitConstructorDeclaration(node, _);
            return (TResult)s;
        }
        finally {
            this.context.setCurrentMethod(null);
        }
    }

    @Override
    public void run(AstNode compilationUnit) {
        compilationUnit.acceptVisitor(this, null);
    }
}

