/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.rm;

import java.io.IOException;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandOperation;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.io.Resource;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.terminal.Shell;

@CommandDefinition(name="rm", description="remove files or directories.")
public class Rm
implements Command<CommandInvocation> {
    @Option(shortName=104, name="help", hasValue=false, description="display this help and exit")
    private boolean help;
    @Option(shortName=100, name="dir", hasValue=false, description="remove empty directories")
    private boolean dir;
    @Option(shortName=105, name="interactive", hasValue=false, description="prompt before every removal")
    private boolean interactive;
    @Option(shortName=118, name="verbose", hasValue=false, description="explain what is being done")
    private boolean verbose;
    @Arguments
    private List<Resource> arguments;

    public CommandResult execute(CommandInvocation commandInvocation) throws IOException, InterruptedException {
        if (this.help || this.arguments == null || this.arguments.isEmpty()) {
            commandInvocation.getShell().out().println(commandInvocation.getHelpInfo("rm"));
            return CommandResult.SUCCESS;
        }
        Resource currentWorkingDirectory = commandInvocation.getAeshContext().getCurrentWorkingDirectory();
        for (Resource r : this.arguments) {
            Shell shell = commandInvocation.getShell();
            Resource resource = (Resource)r.resolve(currentWorkingDirectory).get(0);
            if (this.dir) {
                this.rmDir(resource, commandInvocation);
                continue;
            }
            this.rmFile(resource, commandInvocation);
        }
        return CommandResult.SUCCESS;
    }

    private void rmFile(Resource r, CommandInvocation commandInvocation) throws InterruptedException {
        Shell shell = commandInvocation.getShell();
        if (r.exists()) {
            if (r.isLeaf()) {
                if (this.interactive) {
                    shell.out().println("remove regular file '" + r.getName() + "' ? (y/n)");
                    CommandOperation operation = commandInvocation.getInput();
                    if (operation.getInputKey() == Key.y) {
                        r.delete();
                    }
                } else {
                    r.delete();
                }
                if (this.verbose) {
                    shell.out().println("removed '" + r.getName() + "'");
                }
            } else if (r.isDirectory()) {
                shell.out().println("cannot remove '" + r.getName() + "': Is a directory");
            }
        }
    }

    private void rmDir(Resource r, CommandInvocation commandInvocation) throws InterruptedException {
        Shell shell = commandInvocation.getShell();
        if (r.exists() && r.isDirectory()) {
            if (this.interactive) {
                shell.out().println("remove directory '" + r.getName() + "' ? (y/n)");
                CommandOperation operation = commandInvocation.getInput();
                if (operation.getInputKey() == Key.y) {
                    r.delete();
                }
            } else {
                r.delete();
            }
            if (this.verbose) {
                shell.out().println("removed directory: '" + r.getName() + "'");
            }
        }
    }
}

