/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.text.highlight.scanner;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.jboss.aesh.extensions.text.highlight.Encoder;
import org.jboss.aesh.extensions.text.highlight.Scanner;
import org.jboss.aesh.extensions.text.highlight.StringScanner;
import org.jboss.aesh.extensions.text.highlight.Syntax;
import org.jboss.aesh.extensions.text.highlight.TokenType;
import org.jboss.aesh.extensions.text.highlight.WordList;
import org.jboss.aesh.extensions.text.highlight.scanner.HTMLScanner;

public class JavaScriptScanner
implements Scanner {
    private static final String[] KEYWORDS = new String[]{"break", "case", "catch", "continue", "default", "delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "return", "switch", "throw", "try", "typeof", "var", "void", "while", "with"};
    private static final String[] PREDEFINED_CONSTANTS = new String[]{"false", "null", "true", "undefined", "NaN", "Infinity"};
    private static final String[] MAGIC_VARIABLES = new String[]{"this", "arguments"};
    private static final WordList<Boolean> KEYWORDS_EXPECTING_VALUE = new WordList<Boolean>(false).add(new String[]{"case", "delete", "in", "instanceof", "new", "return", "throw", "typeof", "with"}, true);
    private static final String[] RESERVED_WORDS = new String[]{"abstract", "boolean", "byte", "char", "class", "debugger", "double", "enum", "export", "extends", "final", "float", "goto", "implements", "import", "int", "interface", "long", "native", "package", "private", "protected", "public", "short", "static", "super", "synchronized", "throws", "transient", "volatile"};
    private static final WordList<TokenType> IDENT_KIND = new WordList<TokenType>(TokenType.ident).add(RESERVED_WORDS, TokenType.reserved).add(PREDEFINED_CONSTANTS, TokenType.predefined_constant).add(MAGIC_VARIABLES, TokenType.local_variable).add(KEYWORDS, TokenType.keyword);
    private static final Pattern ESCAPE = Pattern.compile(" [bfnrtv\\n\\\\'\"] | x[a-fA-F0-9]{1,2} | [0-7]{1,3} ", 4);
    private static final Pattern UNICODE_ESCAPE = Pattern.compile(" u[a-fA-F0-9]{4} | U[a-fA-F0-9]{8} ", 4);
    private static final Pattern REGEXP_ESSCAPE = Pattern.compile(" [bBdDsSwW] ", 4);
    private static final Map<String, Pattern> STRING_CONTENT_PATTERN = new HashMap<String, Pattern>();
    private static final Map<String, Pattern> KEY_CHECK_PATTERN = new HashMap<String, Pattern>();
    private static final Pattern SPACE = Pattern.compile(" \\s+ | \\\\\\n ", 4);
    private static final Pattern COMMENT = Pattern.compile(" // [^\\n\\\\]* (?: \\\\. [^\\n\\\\]* )* | /\\* (?: .*? \\*/ | .*() ) ", 36);
    private static final Pattern COMMENT_MULTILINE = Pattern.compile(" .*? \\*", 36);
    private static final Pattern COMMENT_MULTILINE_CONTENT = Pattern.compile(" .+ ", 36);
    private static final Pattern NUMBER = Pattern.compile("\\.?\\d");
    private static final Pattern HEX = Pattern.compile("0[xX][0-9A-Fa-f]+");
    private static final Pattern OCTAL = Pattern.compile("(?>0[0-7]+)(?![89.eEfF])");
    private static final Pattern FLOAT = Pattern.compile("\\d+[fF]|\\d*\\.\\d+(?:[eE][+-]?\\d+)?[fF]?|\\d+[eE][+-]?\\d+[fF]?");
    private static final Pattern INTEGER = Pattern.compile("\\d+");
    private static final Pattern HTML = Pattern.compile("<(\\p{Alpha}\\w*) (?: [^\\/>]*\\/> | .*?<\\/\\1>)", 38);
    private static final Pattern OPERATOR = Pattern.compile(" [-+*=<>?:;,!&^|(\\[{~%]+ | \\.(?!\\d) ", 4);
    private static final Pattern OPERATOR_END = Pattern.compile(" [)\\]}]+ ", 4);
    private static final Pattern IDENT = Pattern.compile(" [$a-zA-Z_][A-Za-z_0-9$]* ", 4);
    private static final Pattern FUNCTION = Pattern.compile("\\s*[=:]\\s*function\\b");
    private static final Pattern KEY = Pattern.compile("\\s*:");
    private static final Pattern ARRAY_KEY = Pattern.compile("[\"']");
    private static final Pattern REGEXP = Pattern.compile("\\/");
    private static final Pattern DELIMITER = Pattern.compile("[\"'\\/]");
    private static final Pattern MODIFIER = Pattern.compile("[gim]+");
    private static final Pattern CONTENT = Pattern.compile(" \\\\ (?: " + ESCAPE.pattern() + " | " + UNICODE_ESCAPE.pattern() + ")", 36);
    private static final Pattern CONTENT_2 = Pattern.compile("\\\\.", 32);
    private static final Pattern CONTENT_END = Pattern.compile(" \\\\ | $ ", 4);
    private static final Pattern CHAR = Pattern.compile(" \\\\ (?: " + ESCAPE.pattern() + " | " + REGEXP_ESSCAPE.pattern() + " | " + UNICODE_ESCAPE.pattern() + " ) ", 36);
    public static final Scanner.Type TYPE = new Scanner.Type("JAVASCRIPT", "\\.(js)$");

    public JavaScriptScanner() {
        STRING_CONTENT_PATTERN.put("'", Pattern.compile("[^\\\\']+"));
        STRING_CONTENT_PATTERN.put("\"", Pattern.compile("[^\\\\\"]+"));
        STRING_CONTENT_PATTERN.put("/", Pattern.compile("[^\\\\\\/]+"));
        KEY_CHECK_PATTERN.put("'", Pattern.compile(" (?> [^\\\\']* (?: \\\\. [^\\\\']* )* ) ' \\s* : ", 36));
        KEY_CHECK_PATTERN.put("\"", Pattern.compile(" (?> [^\\\\\"]* (?: \\\\. [^\\\\\"]* )* ) \" \\s* : ", 36));
    }

    @Override
    public Scanner.Type getType() {
        return TYPE;
    }

    @Override
    public void scan(StringScanner source, Encoder encoder, Map<String, Object> options) {
        State state = State.initial;
        String string_delimiter = null;
        boolean value_expected = true;
        boolean key_expected = false;
        boolean function_expected = false;
        block5: while (source.hasMore()) {
            MatchResult m = null;
            switch (state) {
                case initial: {
                    m = source.scan(SPACE);
                    if (m != null) {
                        if (!value_expected && m.group().indexOf("\n") != -1) {
                            value_expected = true;
                        }
                        encoder.textToken(m.group(), TokenType.space);
                        continue block5;
                    }
                    m = source.scan(COMMENT);
                    if (m != null) {
                        value_expected = true;
                        encoder.textToken(m.group(), TokenType.comment);
                        if (m.group(1) == null) continue block5;
                        state = State.open_multi_line_comment;
                        continue block5;
                    }
                    m = source.check(NUMBER);
                    if (m != null) {
                        value_expected = false;
                        key_expected = false;
                        m = source.scan(HEX);
                        if (m != null) {
                            encoder.textToken(m.group(), TokenType.hex);
                            continue block5;
                        }
                        m = source.scan(OCTAL);
                        if (m != null) {
                            encoder.textToken(m.group(), TokenType.octal);
                            continue block5;
                        }
                        m = source.scan(FLOAT);
                        if (m != null) {
                            encoder.textToken(m.group(), TokenType.float_);
                            continue block5;
                        }
                        m = source.scan(INTEGER);
                        if (m == null) continue block5;
                        encoder.textToken(m.group(), TokenType.integer);
                        continue block5;
                    }
                    if (value_expected && (m = source.scan(HTML)) != null) {
                        Syntax.Builder.create().scannerType(HTMLScanner.TYPE.getName()).encoder(encoder).execute(m.group());
                        value_expected = true;
                        continue block5;
                    }
                    m = source.scan(OPERATOR);
                    if (m != null) {
                        value_expected = true;
                        String last_operator = m.group().substring(m.group().length() - 1);
                        key_expected = last_operator.equals("{") || last_operator.equals(",");
                        function_expected = false;
                        encoder.textToken(m.group(), TokenType.operator);
                        continue block5;
                    }
                    m = source.scan(OPERATOR_END);
                    if (m != null) {
                        value_expected = false;
                        key_expected = false;
                        function_expected = false;
                        encoder.textToken(m.group(), TokenType.operator);
                        continue block5;
                    }
                    m = source.scan(IDENT);
                    if (m != null) {
                        TokenType kind = IDENT_KIND.lookup(m.group());
                        boolean bl = value_expected = kind == TokenType.keyword && KEYWORDS_EXPECTING_VALUE.lookup(m.group()) != false;
                        if (TokenType.ident == kind) {
                            if (m.group().indexOf("$") != -1) {
                                kind = TokenType.predefined;
                            } else if (function_expected) {
                                kind = TokenType.function;
                            } else if (source.check(FUNCTION) != null) {
                                kind = TokenType.function;
                            } else if (key_expected && source.check(KEY) != null) {
                                kind = TokenType.key;
                            }
                        }
                        function_expected = kind == TokenType.keyword && m.group().equals("function");
                        key_expected = false;
                        encoder.textToken(m.group(), kind);
                        continue block5;
                    }
                    m = source.scan(ARRAY_KEY);
                    if (m != null) {
                        state = key_expected && source.check(KEY_CHECK_PATTERN.get(m.group())) != null ? State.key : State.string;
                        encoder.beginGroup(TokenType.valueOf(state.name()));
                        string_delimiter = m.group();
                        encoder.textToken(m.group(), TokenType.delimiter);
                        continue block5;
                    }
                    if (value_expected && (m = source.scan(REGEXP)) != null) {
                        encoder.beginGroup(TokenType.regexp);
                        state = State.regexp;
                        string_delimiter = "/";
                        encoder.textToken(m.group(), TokenType.delimiter);
                        continue block5;
                    }
                    m = source.scan(REGEXP);
                    if (m != null) {
                        value_expected = true;
                        key_expected = false;
                        encoder.textToken(m.group(), TokenType.operator);
                        continue block5;
                    }
                    encoder.textToken(source.next(), TokenType.error);
                    continue block5;
                }
                case string: 
                case regexp: 
                case key: {
                    m = source.scan(STRING_CONTENT_PATTERN.get(string_delimiter));
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.content);
                        continue block5;
                    }
                    m = source.scan(DELIMITER);
                    if (m != null) {
                        MatchResult modifiers;
                        encoder.textToken(m.group(), TokenType.delimiter);
                        if (State.regexp == state && (modifiers = source.scan(MODIFIER)) != null) {
                            encoder.textToken(modifiers.group(), TokenType.modifier);
                        }
                        encoder.endGroup(TokenType.valueOf(state.name()));
                        string_delimiter = null;
                        value_expected = false;
                        key_expected = false;
                        state = State.initial;
                        continue block5;
                    }
                    if (State.regexp != state && (m = source.scan(CONTENT)) != null) {
                        if (string_delimiter.equals("'") && !m.group().equals("\\\\") && !m.group().equals("\\'")) {
                            encoder.textToken(m.group(), TokenType.content);
                            continue block5;
                        }
                        encoder.textToken(m.group(), TokenType.char_);
                        continue block5;
                    }
                    if (State.regexp == state && (m = source.scan(CHAR)) != null) {
                        encoder.textToken(m.group(), TokenType.char_);
                        continue block5;
                    }
                    m = source.scan(CONTENT_2);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.content);
                        continue block5;
                    }
                    m = source.scan(CONTENT_END);
                    if (m != null) {
                        encoder.endGroup(TokenType.valueOf(state.name()));
                        if (!m.group().isEmpty()) {
                            encoder.textToken(m.group(), TokenType.error);
                        }
                        string_delimiter = null;
                        value_expected = false;
                        key_expected = false;
                        state = State.initial;
                        continue block5;
                    }
                    throw new RuntimeException("else case " + string_delimiter + " reached; " + source.peek(1) + " not handled");
                }
                case open_multi_line_comment: {
                    m = source.scan(COMMENT_MULTILINE);
                    if (m != null) {
                        state = State.initial;
                    } else {
                        m = source.scan(COMMENT_MULTILINE_CONTENT);
                    }
                    value_expected = true;
                    if (m == null) continue block5;
                    encoder.textToken(m.group(), TokenType.comment);
                    continue block5;
                }
            }
            throw new RuntimeException("Unknown state " + (Object)((Object)state));
        }
    }

    public static enum State {
        initial,
        open_multi_line_comment,
        key,
        string,
        regexp;

    }
}

