/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.util.xml.LocationAwareXmlReader;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlFileService
extends GraphService<XmlFileModel> {
    private static final Logger LOG = Logger.getLogger(XmlFileService.class.getSimpleName());

    public XmlFileService(GraphContext ctx) {
        super(ctx, XmlFileModel.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document loadDocumentQuiet(XmlFileModel model) {
        ClassificationService classificationService = new ClassificationService(this.getGraphContext());
        try (InputStream is = model.asInputStream();){
            Document doc;
            Document document = doc = LocationAwareXmlReader.readXML((InputStream)is);
            return document;
        }
        catch (SAXException e) {
            LOG.log(Level.WARNING, "Failed to parse xml entity: " + model.getFilePath() + ", due to: " + e.getMessage(), e);
            classificationService.attachClassification((FileModel)model, "Unparseable XML File", "This file could not be parsed");
            return null;
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to parse xml entity: " + model.getFilePath() + ", due to: " + e.getMessage(), e);
            classificationService.attachClassification((FileModel)model, "Unparseable XML File", "This file could not be parsed");
        }
        return null;
    }
}

