/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio;

import info.aduna.lang.FileFormat;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openrdf.query.resultio.QueryResultFormat;

public class TupleQueryResultFormat
extends QueryResultFormat {
    public static final TupleQueryResultFormat SPARQL = new TupleQueryResultFormat("SPARQL/XML", Arrays.asList("application/sparql-results+xml", "application/xml"), Charset.forName("UTF-8"), Arrays.asList("srx", "xml"));
    public static final TupleQueryResultFormat BINARY = new TupleQueryResultFormat("BINARY", "application/x-binary-rdf-results-table", null, "brt");
    public static final TupleQueryResultFormat JSON = new TupleQueryResultFormat("SPARQL/JSON", Arrays.asList("application/sparql-results+json", "application/json"), Charset.forName("UTF-8"), Arrays.asList("srj", "json"));
    public static final TupleQueryResultFormat CSV = new TupleQueryResultFormat("SPARQL/CSV", "text/csv", Charset.forName("UTF-8"), "csv");
    public static final TupleQueryResultFormat TSV = new TupleQueryResultFormat("SPARQL/TSV", "text/tab-separated-values", Charset.forName("UTF-8"), "tsv");
    private static List<TupleQueryResultFormat> VALUES = new ArrayList<TupleQueryResultFormat>(8);

    public static Collection<TupleQueryResultFormat> values() {
        return Collections.unmodifiableList(VALUES);
    }

    public static TupleQueryResultFormat register(String name, String mimeType, String fileExt) {
        TupleQueryResultFormat format = new TupleQueryResultFormat(name, mimeType, fileExt);
        TupleQueryResultFormat.register(format);
        return format;
    }

    public static void register(TupleQueryResultFormat format) {
        VALUES.add(format);
    }

    public static TupleQueryResultFormat forMIMEType(String mimeType) {
        return TupleQueryResultFormat.forMIMEType(mimeType, null);
    }

    public static TupleQueryResultFormat forMIMEType(String mimeType, TupleQueryResultFormat fallback) {
        return (TupleQueryResultFormat)TupleQueryResultFormat.matchMIMEType((String)mimeType, VALUES, (FileFormat)fallback);
    }

    public static TupleQueryResultFormat forFileName(String fileName) {
        return TupleQueryResultFormat.forFileName(fileName, null);
    }

    public static TupleQueryResultFormat forFileName(String fileName, TupleQueryResultFormat fallback) {
        return (TupleQueryResultFormat)TupleQueryResultFormat.matchFileName((String)fileName, VALUES, (FileFormat)fallback);
    }

    public TupleQueryResultFormat(String name, String mimeType, String fileExt) {
        this(name, mimeType, null, fileExt);
    }

    public TupleQueryResultFormat(String name, String mimeType, Charset charset, String fileExt) {
        super(name, mimeType, charset, fileExt);
    }

    public TupleQueryResultFormat(String name, Collection<String> mimeTypes, Charset charset, Collection<String> fileExtensions) {
        super(name, mimeTypes, charset, fileExtensions);
    }

    static {
        TupleQueryResultFormat.register(SPARQL);
        TupleQueryResultFormat.register(BINARY);
        TupleQueryResultFormat.register(JSON);
        TupleQueryResultFormat.register(CSV);
        TupleQueryResultFormat.register(TSV);
    }
}

