/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memory;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.memory.AbstractMemoryManager;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.ByteBufferAware;
import org.glassfish.grizzly.memory.ByteBufferWrapper;
import org.glassfish.grizzly.memory.MemoryProbe;
import org.glassfish.grizzly.memory.ProbeNotifier;
import org.glassfish.grizzly.memory.ThreadLocalPool;
import org.glassfish.grizzly.memory.WrapperAware;
import org.glassfish.grizzly.monitoring.jmx.JmxMonitoringConfig;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;

public class ByteBufferManager
extends AbstractMemoryManager<ByteBufferWrapper>
implements WrapperAware,
ByteBufferAware {
    public static final int DEFAULT_SMALL_BUFFER_SIZE = 32;
    private static final ThreadCache.CachedTypeIndex<TrimAwareWrapper> CACHE_IDX = ThreadCache.obtainIndex(TrimAwareWrapper.class, 2);
    private final ThreadCache.CachedTypeIndex<SmallByteBufferWrapper> SMALL_BUFFER_CACHE_IDX = ThreadCache.obtainIndex(SmallByteBufferWrapper.class.getName() + '.' + System.identityHashCode(this), SmallByteBufferWrapper.class, 16);
    protected boolean isDirect;
    protected final int maxSmallBufferSize;

    public ByteBufferManager() {
        this(false, 65536, 32);
    }

    public ByteBufferManager(boolean isDirect, int maxBufferSize, int maxSmallBufferSize) {
        super(maxBufferSize);
        this.maxSmallBufferSize = maxSmallBufferSize;
        this.isDirect = isDirect;
    }

    public int getMaxSmallBufferSize() {
        return this.maxSmallBufferSize;
    }

    @Override
    public ByteBufferWrapper allocate(int size) {
        if (size <= this.maxSmallBufferSize) {
            SmallByteBufferWrapper buffer = this.createSmallBuffer();
            buffer.limit(size);
            return buffer;
        }
        return this.wrap(this.allocateByteBuffer(size));
    }

    @Override
    public ByteBufferWrapper allocateAtLeast(int size) {
        if (size <= this.maxSmallBufferSize) {
            SmallByteBufferWrapper buffer = this.createSmallBuffer();
            buffer.limit(size);
            return buffer;
        }
        return this.wrap(this.allocateByteBufferAtLeast(size));
    }

    @Override
    public ByteBufferWrapper reallocate(ByteBufferWrapper oldBuffer, int newSize) {
        return this.wrap(this.reallocateByteBuffer(oldBuffer.underlying(), newSize));
    }

    @Override
    public void release(ByteBufferWrapper buffer) {
        this.releaseByteBuffer(buffer.underlying());
    }

    public boolean isDirect() {
        return this.isDirect;
    }

    public void setDirect(boolean isDirect) {
        this.isDirect = isDirect;
    }

    @Override
    public boolean willAllocateDirect(int size) {
        return this.isDirect;
    }

    @Override
    public ByteBufferWrapper wrap(byte[] data) {
        return this.wrap(data, 0, data.length);
    }

    @Override
    public ByteBufferWrapper wrap(byte[] data, int offset, int length) {
        return this.wrap(ByteBuffer.wrap(data, offset, length));
    }

    @Override
    public ByteBufferWrapper wrap(String s) {
        return this.wrap(s, Charset.defaultCharset());
    }

    @Override
    public ByteBufferWrapper wrap(String s, Charset charset) {
        try {
            byte[] byteRepresentation = s.getBytes(charset.name());
            return this.wrap(ByteBuffer.wrap(byteRepresentation));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public ThreadLocalPool createThreadLocalPool() {
        return new ByteBufferThreadLocalPool();
    }

    @Override
    public ByteBufferWrapper wrap(ByteBuffer byteBuffer) {
        return this.createTrimAwareBuffer(byteBuffer);
    }

    @Override
    public ByteBuffer allocateByteBuffer(int size) {
        if (size > this.maxBufferSize) {
            return this.allocateByteBuffer0(size);
        }
        ByteBufferThreadLocalPool threadLocalCache = ByteBufferManager.getByteBufferThreadLocalPool();
        if (threadLocalCache != null) {
            int remaining = threadLocalCache.remaining();
            if (remaining == 0 || remaining < size) {
                this.reallocatePoolBuffer();
            }
            return (ByteBuffer)this.allocateFromPool(threadLocalCache, size);
        }
        return this.allocateByteBuffer0(size);
    }

    @Override
    public ByteBuffer allocateByteBufferAtLeast(int size) {
        if (size > this.maxBufferSize) {
            return this.allocateByteBuffer0(size);
        }
        ByteBufferThreadLocalPool threadLocalCache = ByteBufferManager.getByteBufferThreadLocalPool();
        if (threadLocalCache != null) {
            int remaining = threadLocalCache.remaining();
            if (remaining == 0 || remaining < size) {
                this.reallocatePoolBuffer();
                remaining = threadLocalCache.remaining();
            }
            return (ByteBuffer)this.allocateFromPool(threadLocalCache, remaining);
        }
        return this.allocateByteBuffer0(size);
    }

    @Override
    public ByteBuffer reallocateByteBuffer(ByteBuffer oldByteBuffer, int newSize) {
        ByteBuffer newBuffer;
        if (oldByteBuffer.capacity() >= newSize) {
            return oldByteBuffer;
        }
        ByteBufferThreadLocalPool memoryPool = ByteBufferManager.getByteBufferThreadLocalPool();
        if (memoryPool != null && (newBuffer = memoryPool.reallocate(oldByteBuffer, newSize)) != null) {
            ProbeNotifier.notifyBufferAllocatedFromPool(this.monitoringConfig, newSize - oldByteBuffer.capacity());
            return newBuffer;
        }
        ByteBuffer newByteBuffer = this.allocateByteBuffer(newSize);
        oldByteBuffer.flip();
        return newByteBuffer.put(oldByteBuffer);
    }

    @Override
    public void releaseByteBuffer(ByteBuffer byteBuffer) {
        ByteBufferThreadLocalPool memoryPool = ByteBufferManager.getByteBufferThreadLocalPool();
        if (memoryPool != null && memoryPool.release((ByteBuffer)byteBuffer.clear())) {
            ProbeNotifier.notifyBufferReleasedToPool(this.monitoringConfig, byteBuffer.capacity());
        }
    }

    protected SmallByteBufferWrapper createSmallBuffer() {
        SmallByteBufferWrapper buffer = ThreadCache.takeFromCache(this.SMALL_BUFFER_CACHE_IDX);
        if (buffer != null) {
            ProbeNotifier.notifyBufferAllocatedFromPool(this.monitoringConfig, this.maxSmallBufferSize);
            return buffer;
        }
        return new SmallByteBufferWrapper(this.allocateByteBuffer0(this.maxSmallBufferSize));
    }

    @Override
    public JmxMonitoringConfig<MemoryProbe> getMonitoringConfig() {
        return this.monitoringConfig;
    }

    @Override
    protected JmxObject createJmxManagementObject() {
        return new org.glassfish.grizzly.memory.jmx.ByteBufferManager(this);
    }

    protected final ByteBuffer allocateByteBuffer0(int size) {
        ProbeNotifier.notifyBufferAllocated(this.monitoringConfig, size);
        if (this.isDirect) {
            return ByteBuffer.allocateDirect(size);
        }
        return ByteBuffer.allocate(size);
    }

    private TrimAwareWrapper createTrimAwareBuffer(ByteBuffer underlyingByteBuffer) {
        TrimAwareWrapper buffer = ThreadCache.takeFromCache(CACHE_IDX);
        if (buffer != null) {
            buffer.visible = underlyingByteBuffer;
            return buffer;
        }
        return new TrimAwareWrapper(underlyingByteBuffer);
    }

    private void reallocatePoolBuffer() {
        ByteBuffer byteBuffer = this.allocateByteBuffer0(this.maxBufferSize);
        ByteBufferThreadLocalPool threadLocalCache = ByteBufferManager.getByteBufferThreadLocalPool();
        if (threadLocalCache != null) {
            threadLocalCache.reset(byteBuffer);
        }
    }

    private static ByteBufferThreadLocalPool getByteBufferThreadLocalPool() {
        ThreadLocalPool pool = ByteBufferManager.getThreadLocalPool();
        return pool instanceof ByteBufferThreadLocalPool ? (ByteBufferThreadLocalPool)pool : null;
    }

    protected final class SmallByteBufferWrapper
    extends ByteBufferWrapper
    implements Cacheable {
        private SmallByteBufferWrapper(ByteBuffer underlyingByteBuffer) {
            super(underlyingByteBuffer);
        }

        @Override
        public void dispose() {
            super.prepareDispose();
            this.visible.clear();
            this.recycle();
        }

        @Override
        public void recycle() {
            if (this.visible.remaining() == ByteBufferManager.this.maxSmallBufferSize) {
                this.allowBufferDispose = false;
                this.disposeStackTrace = null;
                if (ThreadCache.putToCache(ByteBufferManager.this.SMALL_BUFFER_CACHE_IDX, this)) {
                    ProbeNotifier.notifyBufferReleasedToPool(ByteBufferManager.this.monitoringConfig, ByteBufferManager.this.maxSmallBufferSize);
                }
            }
        }

        @Override
        protected ByteBufferWrapper wrapByteBuffer(ByteBuffer byteBuffer) {
            return ByteBufferManager.this.wrap(byteBuffer);
        }
    }

    private final class TrimAwareWrapper
    extends ByteBufferWrapper
    implements AbstractMemoryManager.TrimAware {
        private TrimAwareWrapper(ByteBuffer underlyingByteBuffer) {
            super(underlyingByteBuffer);
        }

        @Override
        public void trim() {
            ByteBufferThreadLocalPool threadLocalCache;
            int sizeToReturn = this.visible.capacity() - this.visible.position();
            if (sizeToReturn > 0 && (threadLocalCache = ByteBufferManager.getByteBufferThreadLocalPool()) != null) {
                if (threadLocalCache.isLastAllocated(this.visible)) {
                    this.visible.flip();
                    this.visible = this.visible.slice();
                    threadLocalCache.reduceLastAllocated(this.visible);
                    return;
                }
                if (threadLocalCache.wantReset(sizeToReturn)) {
                    this.visible.flip();
                    ByteBuffer originalByteBuffer = this.visible;
                    this.visible = this.visible.slice();
                    originalByteBuffer.position(originalByteBuffer.limit());
                    originalByteBuffer.limit(originalByteBuffer.capacity());
                    threadLocalCache.reset(originalByteBuffer);
                    return;
                }
            }
            super.trim();
        }

        @Override
        public void recycle() {
            this.allowBufferDispose = false;
            ThreadCache.putToCache(CACHE_IDX, this);
        }

        @Override
        public void dispose() {
            this.prepareDispose();
            ByteBufferManager.this.release(this);
            this.visible = null;
            this.recycle();
        }

        @Override
        protected ByteBufferWrapper wrapByteBuffer(ByteBuffer byteBuffer) {
            return ByteBufferManager.this.wrap(byteBuffer);
        }
    }

    private static final class ByteBufferThreadLocalPool
    implements ThreadLocalPool<ByteBuffer> {
        private ByteBuffer pool;
        private Object[] allocationHistory = new Object[8];
        private int lastAllocatedIndex;

        @Override
        public void reset(ByteBuffer pool) {
            Arrays.fill(this.allocationHistory, 0, this.lastAllocatedIndex, null);
            this.lastAllocatedIndex = 0;
            this.pool = pool;
        }

        @Override
        public ByteBuffer allocate(int size) {
            ByteBuffer allocated = Buffers.slice(this.pool, size);
            return this.addHistory(allocated);
        }

        @Override
        public ByteBuffer reallocate(ByteBuffer oldByteBuffer, int newSize) {
            if (this.isLastAllocated(oldByteBuffer) && this.remaining() + oldByteBuffer.capacity() >= newSize) {
                --this.lastAllocatedIndex;
                this.pool.position(this.pool.position() - oldByteBuffer.capacity());
                ByteBuffer newByteBuffer = Buffers.slice(this.pool, newSize);
                newByteBuffer.position(oldByteBuffer.position());
                return this.addHistory(newByteBuffer);
            }
            return null;
        }

        @Override
        public boolean release(ByteBuffer underlyingBuffer) {
            if (this.isLastAllocated(underlyingBuffer)) {
                this.pool.position(this.pool.position() - underlyingBuffer.capacity());
                this.allocationHistory[--this.lastAllocatedIndex] = null;
                return true;
            }
            if (this.wantReset(underlyingBuffer.capacity())) {
                this.reset(underlyingBuffer);
                return true;
            }
            return false;
        }

        @Override
        public boolean wantReset(int size) {
            return !this.hasRemaining() || this.lastAllocatedIndex == 0 && this.pool.remaining() < size;
        }

        @Override
        public boolean isLastAllocated(ByteBuffer oldByteBuffer) {
            return this.lastAllocatedIndex > 0 && this.allocationHistory[this.lastAllocatedIndex - 1] == oldByteBuffer;
        }

        @Override
        public ByteBuffer reduceLastAllocated(ByteBuffer byteBuffer) {
            ByteBuffer oldLastAllocated = (ByteBuffer)this.allocationHistory[this.lastAllocatedIndex - 1];
            this.pool.position(this.pool.position() - (oldLastAllocated.capacity() - byteBuffer.capacity()));
            this.allocationHistory[this.lastAllocatedIndex - 1] = byteBuffer;
            return oldLastAllocated;
        }

        @Override
        public int remaining() {
            return this.pool != null ? this.pool.remaining() : 0;
        }

        @Override
        public boolean hasRemaining() {
            return this.remaining() > 0;
        }

        private ByteBuffer addHistory(ByteBuffer allocated) {
            if (this.lastAllocatedIndex >= this.allocationHistory.length) {
                this.allocationHistory = Arrays.copyOf(this.allocationHistory, this.allocationHistory.length * 3 / 2 + 1);
            }
            this.allocationHistory[this.lastAllocatedIndex++] = allocated;
            return allocated;
        }

        public String toString() {
            return "(pool=" + this.pool + " last-allocated-index=" + (this.lastAllocatedIndex - 1) + " allocation-history=" + Arrays.toString(this.allocationHistory) + ')';
        }
    }
}

