/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.extension;

import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONMode;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONUtility;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ExtensionResponse {
    private final Response jerseyResponse;
    private final boolean errorResponse;

    public ExtensionResponse(Response response) {
        this(response, false);
    }

    public ExtensionResponse(Response response, boolean errorResponse) {
        this.jerseyResponse = response;
        this.errorResponse = errorResponse;
    }

    public static ExtensionResponse override(Response response) {
        if (response == null) {
            throw new IllegalArgumentException("Response cannot be null");
        }
        return new ExtensionResponse(response);
    }

    public static ExtensionResponse error(String message) {
        return ExtensionResponse.error(message, (Exception)null);
    }

    public static ExtensionResponse error(String message, String appendKey, JSONObject appendJson) {
        return ExtensionResponse.error(message, null, appendKey, appendJson);
    }

    public static ExtensionResponse error(String message, JSONObject appendJson) {
        return ExtensionResponse.error(message, null, null, appendJson);
    }

    public static ExtensionResponse error(Exception source) {
        return ExtensionResponse.error("", source);
    }

    public static ExtensionResponse error(Exception source, String appendKey, JSONObject appendJson) {
        return ExtensionResponse.error("", source, appendKey, appendJson);
    }

    public static ExtensionResponse error(Exception source, JSONObject appendJson) {
        return ExtensionResponse.error("", source, null, appendJson);
    }

    public static ExtensionResponse error(String message, Exception source) {
        return ExtensionResponse.error(message, source, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }

    public static ExtensionResponse error(String message, Exception source, String appendKey, JSONObject appendJson) {
        return ExtensionResponse.error(message, source, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), appendKey, appendJson);
    }

    public static ExtensionResponse error(String message, Exception source, JSONObject appendJson) {
        return ExtensionResponse.error(message, source, null, appendJson);
    }

    public static ExtensionResponse error(String message, Exception source, int statusCode) {
        return ExtensionResponse.error(message, source, statusCode, null, null);
    }

    public static ExtensionResponse error(String message, Exception source, int statusCode, String appendKey, JSONObject appendJson) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("message", message);
        if (source != null) {
            m.put("error", source.getMessage());
        }
        if (appendJson != null) {
            if (appendKey != null && !appendKey.isEmpty()) {
                m.put(appendKey, appendJson);
            } else {
                Iterator keys = appendJson.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    m.put(key, appendJson.opt(key));
                }
            }
        }
        return new ExtensionResponse(Response.status((int)statusCode).entity((Object)new JSONObject(m)).build(), true);
    }

    public static ExtensionResponse noContent() {
        return new ExtensionResponse(Response.noContent().build());
    }

    public static ExtensionResponse ok(Map result) {
        if (result == null) {
            throw new IllegalArgumentException("result cannot be null");
        }
        return ExtensionResponse.ok(new JSONObject(result));
    }

    public static ExtensionResponse ok(Element result) {
        return ExtensionResponse.ok(result, null, GraphSONMode.NORMAL);
    }

    public static ExtensionResponse ok(Element result, Set<String> propertyKeys, GraphSONMode mode) {
        if (result == null) {
            throw new IllegalArgumentException("result cannot be null");
        }
        try {
            return ExtensionResponse.ok(GraphSONUtility.jsonFromElement((Element)result, propertyKeys, (GraphSONMode)mode));
        }
        catch (JSONException jsonException) {
            throw new RuntimeException(jsonException);
        }
    }

    public static ExtensionResponse ok(Iterator<Element> result) {
        return ExtensionResponse.ok(result, null, GraphSONMode.NORMAL);
    }

    public static ExtensionResponse ok(Iterator<Element> result, Set<String> propertyKeys, GraphSONMode mode) {
        if (result == null) {
            throw new IllegalArgumentException("result cannot be null");
        }
        JSONObject json = new JSONObject();
        JSONArray elementArray = new JSONArray();
        try {
            while (result.hasNext()) {
                elementArray.put((Object)GraphSONUtility.jsonFromElement((Element)result.next(), propertyKeys, (GraphSONMode)mode));
            }
            json.put("results", (Object)elementArray);
        }
        catch (JSONException jsone) {
            throw new RuntimeException(jsone);
        }
        return ExtensionResponse.ok(json);
    }

    public static ExtensionResponse availableOptions(String ... methods) {
        return new ExtensionResponse(Response.noContent().header("Access-Control-Allow-Methods", (Object)StringUtils.join((Object[])methods, (String)",")).build());
    }

    public static ExtensionResponse ok(JSONObject result) {
        return new ExtensionResponse(Response.ok((Object)result).build());
    }

    public static ExtensionResponse badRequest(String message, JSONObject appendJson) {
        return ExtensionResponse.error(message, null, Response.Status.BAD_REQUEST.getStatusCode(), null, appendJson);
    }

    public static ExtensionResponse badRequest() {
        return new ExtensionResponse(Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
    }

    public Response getJerseyResponse() {
        return this.jerseyResponse;
    }

    public boolean isErrorResponse() {
        return this.errorResponse;
    }
}

