/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.connector.file;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.file.FileRepositoryWorker;
import org.eclipse.aether.connector.file.ParallelRepositoryConnector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.ArtifactUpload;
import org.eclipse.aether.spi.connector.MetadataDownload;
import org.eclipse.aether.spi.connector.MetadataUpload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.util.concurrency.RunnableErrorForwarder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileRepositoryConnector
extends ParallelRepositoryConnector
implements RepositoryConnector {
    private RemoteRepository repository;
    private RepositorySystemSession session;
    private Logger logger = NullLoggerFactory.LOGGER;
    private FileProcessor fileProcessor;

    public FileRepositoryConnector(RepositorySystemSession session, RemoteRepository repository, FileProcessor fileProcessor, Logger logger) throws NoRepositoryConnectorException {
        if (!"default".equals(repository.getContentType())) {
            throw new NoRepositoryConnectorException(repository);
        }
        this.session = session;
        this.repository = repository;
        this.fileProcessor = fileProcessor;
        this.logger = logger;
        this.initExecutor(session.getConfigProperties());
    }

    public void get(Collection<? extends ArtifactDownload> artifactDownloads, Collection<? extends MetadataDownload> metadataDownloads) {
        FileRepositoryWorker worker;
        this.checkClosed();
        artifactDownloads = this.notNull(artifactDownloads);
        metadataDownloads = this.notNull(metadataDownloads);
        RunnableErrorForwarder errorForwarder = new RunnableErrorForwarder();
        for (ArtifactDownload artifactDownload : artifactDownloads) {
            worker = new FileRepositoryWorker(artifactDownload, this.repository, this.session);
            worker.setLogger(this.logger);
            worker.setFileProcessor(this.fileProcessor);
            this.executor.execute(errorForwarder.wrap((Runnable)worker));
        }
        for (MetadataDownload metadataDownload : metadataDownloads) {
            worker = new FileRepositoryWorker(metadataDownload, this.repository, this.session);
            worker.setLogger(this.logger);
            worker.setFileProcessor(this.fileProcessor);
            this.executor.execute(errorForwarder.wrap((Runnable)worker));
        }
        errorForwarder.await();
    }

    private <E> Collection<E> notNull(Collection<E> col) {
        return col == null ? Collections.emptyList() : col;
    }

    public void put(Collection<? extends ArtifactUpload> artifactUploads, Collection<? extends MetadataUpload> metadataUploads) {
        FileRepositoryWorker worker;
        this.checkClosed();
        artifactUploads = this.notNull(artifactUploads);
        metadataUploads = this.notNull(metadataUploads);
        RunnableErrorForwarder errorForwarder = new RunnableErrorForwarder();
        for (ArtifactUpload artifactUpload : artifactUploads) {
            worker = new FileRepositoryWorker(artifactUpload, this.repository, this.session);
            worker.setLogger(this.logger);
            worker.setFileProcessor(this.fileProcessor);
            this.executor.execute(errorForwarder.wrap((Runnable)worker));
        }
        for (MetadataUpload metadataUpload : metadataUploads) {
            worker = new FileRepositoryWorker(metadataUpload, this.repository, this.session);
            worker.setLogger(this.logger);
            worker.setFileProcessor(this.fileProcessor);
            this.executor.execute(errorForwarder.wrap((Runnable)worker));
        }
        errorForwarder.await();
    }

    public String toString() {
        return String.valueOf(this.repository);
    }
}

