/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.client;

import com.tinkerpop.rexster.client.RexsterClient;
import com.tinkerpop.rexster.client.RexsterClientFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.log4j.BasicConfigurator;

public class TryRexProSessionless
implements Runnable {
    private int cycle = 0;
    private final String host;
    private final int exerciseTime;
    private final String graphName;

    public static void main(String[] args) throws Exception {
        int c = Integer.parseInt(args[1]);
        int exerciseTime = Integer.parseInt(args[2]) * 60 * 1000;
        for (int ix = 0; ix < c; ++ix) {
            if (args.length == 4) {
                new Thread(new TryRexProSessionless(args[0], exerciseTime, args[3])).start();
                continue;
            }
            new Thread(new TryRexProSessionless(args[0], exerciseTime, "gratefulgraph")).start();
        }
        Thread.currentThread().join();
        System.exit(0);
    }

    public TryRexProSessionless(String host, int exerciseTime, String graphName) {
        this.exerciseTime = exerciseTime;
        this.host = host;
        this.graphName = graphName;
    }

    @Override
    public void run() {
        this.lotsOfCalls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lotsOfCalls() {
        long start = System.currentTimeMillis();
        long checkpoint = System.currentTimeMillis();
        Random random = new Random();
        RexsterClient client = null;
        try {
            client = RexsterClientFactory.open(this.host, this.graphName);
            while (System.currentTimeMillis() - start < (long)this.exerciseTime) {
                ++this.cycle;
                System.out.println("Exercise cycle: " + this.cycle);
                try {
                    int counter = 1;
                    int vRequestCount = random.nextInt(500);
                    for (int iv = 1; iv < vRequestCount; ++iv) {
                        HashMap<String, Object> scriptArgs = new HashMap<String, Object>();
                        scriptArgs.put("id", random.nextInt(800));
                        List innerResults = client.execute("g.v(id)", scriptArgs);
                        System.out.println(innerResults.get(0));
                        ++counter;
                    }
                    int eRequestCount = random.nextInt(500);
                    for (int ie = 1; ie < eRequestCount; ++ie) {
                        HashMap<String, Object> scriptArgs = new HashMap<String, Object>();
                        scriptArgs.put("id", random.nextInt(8000));
                        List innerResults = client.execute("g.e(id)", scriptArgs);
                        System.out.println(innerResults.get(0));
                        ++counter;
                    }
                    int gRequestCount = random.nextInt(1000);
                    for (int ig = 1; ig < gRequestCount; ++ig) {
                        HashMap<String, Object> scriptArgs = new HashMap<String, Object>();
                        scriptArgs.put("id", random.nextInt(800));
                        List innerResults = client.execute("g.v(id).out('followed_by').loop(1){it.loops<3}[0..10]", scriptArgs);
                        System.out.println(innerResults.size() > 0 ? innerResults.get(0) : "no results");
                        ++counter;
                    }
                    long end = System.currentTimeMillis() - checkpoint;
                    System.out.println(checkpoint - start + ":" + end);
                    System.out.println((long)counter / (end / 1000L));
                }
                catch (Exception ex) {
                    System.out.println("Error during TEST CYCLE (stack trace follows)");
                    ex.printStackTrace();
                    if (ex.getCause() == null) continue;
                    System.out.println("There is an inner exception (stack trace follows)");
                    ex.getCause().printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (Exception e) {}
            }
        }
    }

    static {
        BasicConfigurator.configure();
    }
}

