/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol;

import com.tinkerpop.gremlin.groovy.jsr223.DefaultImportCustomizerProvider;
import com.tinkerpop.rexster.protocol.EngineConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.apache.log4j.Logger;

public class EngineHolder {
    private static final Logger logger = Logger.getLogger(EngineHolder.class);
    private final String languageName;
    private final String languageVersion;
    private final String engineName;
    private final String engineVersion;
    private final Set<String> initScriptFiles;
    private final ScriptEngineFactory factory;
    private final int engineResetThreshold;
    private ScriptEngine engine;
    private AtomicInteger numberOfScriptsEvaluated = new AtomicInteger(1);

    public EngineHolder(ScriptEngineFactory factory, EngineConfiguration configuration) {
        this.languageName = factory.getLanguageName();
        this.languageVersion = factory.getLanguageVersion();
        this.engineName = factory.getEngineName();
        this.engineVersion = factory.getEngineVersion();
        this.engineResetThreshold = configuration.getResetCount();
        this.initScriptFiles = configuration.getInitScriptFiles();
        this.factory = factory;
        if (this.languageName.equals("gremlin-groovy")) {
            logger.info((Object)"Initializing gremlin-groovy engine with additional imports.");
            DefaultImportCustomizerProvider.initializeStatically(configuration.getImports(), configuration.getStaticImports());
        }
        this.engine = EngineHolder.initEngine(this.factory, this.initScriptFiles);
    }

    public String getEngineName() {
        return this.engineName;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public ScriptEngine getEngine() {
        if (this.engine == null) {
            this.engine = EngineHolder.initEngine(this.factory, this.initScriptFiles);
        }
        return this.engine;
    }

    private static ScriptEngine initEngine(ScriptEngineFactory factory, Set<String> scriptFiles) {
        ScriptEngine engine = factory.getScriptEngine();
        for (String scriptFile : scriptFiles) {
            if (scriptFile == null || scriptFile.isEmpty()) continue;
            File scriptEngineInitFile = new File(scriptFile);
            if (scriptEngineInitFile.exists()) {
                try {
                    FileReader reader = new FileReader(scriptEngineInitFile);
                    logger.info((Object)"ScriptEngine initializing with a custom script");
                    engine.eval(reader);
                }
                catch (FileNotFoundException fnfe) {
                    logger.warn((Object)String.format("Could not read ScriptEngine initialization file.  Check location of [%s].", scriptEngineInitFile.getAbsolutePath()));
                }
                catch (ScriptException ex) {
                    logger.warn((Object)String.format("ScriptEngine initialization failure. Custom scripts and imports will not be initialized by [%s].", scriptEngineInitFile.getAbsolutePath()), (Throwable)ex);
                }
                continue;
            }
            logger.warn((Object)String.format("ScriptEngine initialization file does not exist.  Check location of [%s].", scriptEngineInitFile.getAbsolutePath()));
        }
        return engine;
    }
}

