/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol.filter;

import com.tinkerpop.rexster.protocol.server.IncompleteRexProRequestException;
import com.tinkerpop.rexster.protocol.server.RexProRequest;
import com.tinkerpop.rexster.server.RexsterApplication;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.memory.MemoryManager;

public class RexProServerFilter
extends BaseFilter {
    private static final Logger logger = Logger.getLogger(RexProServerFilter.class);
    private RexsterApplication rexsterApplication;

    public RexProServerFilter(RexsterApplication application) {
        this.rexsterApplication = application;
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer remainder;
        Buffer sourceBuffer = (Buffer)ctx.getMessage();
        int sourceBufferLength = sourceBuffer.remaining();
        if (sourceBufferLength < 1) {
            return ctx.getStopAction((Object)sourceBuffer);
        }
        RexProRequest request = null;
        byte messageVersion = sourceBuffer.get(0);
        try {
            switch (messageVersion) {
                case 1: {
                    request = new RexProRequest(sourceBuffer.toByteBuffer(), sourceBufferLength, this.rexsterApplication);
                    break;
                }
                default: {
                    logger.warn((Object)("unsupported rexpro version: " + messageVersion));
                    return ctx.getStopAction();
                }
            }
        }
        catch (IncompleteRexProRequestException ex) {
            logger.warn((Object)ex);
            return ctx.getStopAction((Object)sourceBuffer);
        }
        Buffer buffer = remainder = sourceBufferLength > request.getCompleteRequestMessageLength() ? sourceBuffer.split(request.getCompleteRequestMessageLength()) : null;
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (byte b : request.getRequestMessageBytes()) {
                sb.append(StringUtils.rightPad((String)Byte.toString(b), (int)4));
                sb.append(" ");
            }
            logger.debug((Object)String.format("Received message [version:%s][message type:%s][body length:%s][body:%s]", messageVersion, request.getRequestMessageType(), request.getRequestBodyLength(), sb.toString().trim()));
        }
        ctx.setMessage((Object)request);
        sourceBuffer.tryDispose();
        return ctx.getInvokeAction((Object)remainder);
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        RexProRequest request = (RexProRequest)ctx.getMessage();
        MemoryManager memoryManager = ctx.getConnection().getTransport().getMemoryManager();
        Buffer bb = memoryManager.allocate(request.getResponseSize());
        request.writeToBuffer(bb);
        bb.allowBufferDispose(true);
        ctx.setMessage((Object)bb.flip());
        return ctx.getInvokeAction();
    }
}

