/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol.serializer.msgpack;

import com.tinkerpop.rexster.protocol.msg.ErrorResponseMessage;
import com.tinkerpop.rexster.protocol.msg.RexProBindings;
import com.tinkerpop.rexster.protocol.msg.RexProMessage;
import com.tinkerpop.rexster.protocol.msg.RexProMessageMeta;
import com.tinkerpop.rexster.protocol.msg.RexProScriptResult;
import com.tinkerpop.rexster.protocol.msg.ScriptRequestMessage;
import com.tinkerpop.rexster.protocol.msg.ScriptResponseMessage;
import com.tinkerpop.rexster.protocol.msg.SessionRequestMessage;
import com.tinkerpop.rexster.protocol.msg.SessionResponseMessage;
import com.tinkerpop.rexster.protocol.serializer.RexProSerializer;
import com.tinkerpop.rexster.protocol.serializer.msgpack.templates.MetaTemplate;
import com.tinkerpop.rexster.protocol.serializer.msgpack.templates.ResultsTemplate;
import com.tinkerpop.rexster.protocol.serializer.msgpack.templates.messages.ErrorResponseMessageTemplate;
import com.tinkerpop.rexster.protocol.serializer.msgpack.templates.messages.MsgPackScriptResponseMessageTemplate;
import com.tinkerpop.rexster.protocol.serializer.msgpack.templates.messages.ScriptRequestMessageTemplate;
import com.tinkerpop.rexster.protocol.serializer.msgpack.templates.messages.SessionRequestMessageTemplate;
import com.tinkerpop.rexster.protocol.serializer.msgpack.templates.messages.SessionResponseMessageTemplate;
import java.io.IOException;
import org.msgpack.MessagePack;
import org.msgpack.packer.BufferPacker;
import org.msgpack.packer.Packer;
import org.msgpack.template.Template;
import org.msgpack.unpacker.BufferUnpacker;
import org.msgpack.unpacker.Unpacker;

public class MsgPackSerializer
implements RexProSerializer {
    public static final byte SERIALIZER_ID = 0;
    private static final MessagePack msgpack = new MessagePack();

    @Override
    public <Message extends RexProMessage> Message deserialize(byte[] bytes, Class<Message> messageClass) throws IOException {
        BufferUnpacker un = msgpack.createBufferUnpacker(bytes);
        return (Message)((RexProMessage)msgpack.lookup(messageClass).read((Unpacker)un, null));
    }

    @Override
    public <Message extends RexProMessage> byte[] serialize(Message message, Class<Message> messageClass) throws IOException {
        BufferPacker pk = msgpack.createBufferPacker();
        msgpack.lookup(messageClass).write((Packer)pk, message);
        return pk.toByteArray();
    }

    @Override
    public byte getSerializerId() {
        return 0;
    }

    static {
        msgpack.register(RexProMessageMeta.class, (Template)new MetaTemplate());
        msgpack.register(RexProBindings.class, (Template)RexProBindings.SerializationTemplate.getInstance());
        msgpack.register(RexProScriptResult.class, (Template)ResultsTemplate.getInstance());
        msgpack.register(ErrorResponseMessage.class, (Template)new ErrorResponseMessageTemplate());
        msgpack.register(SessionRequestMessage.class, (Template)new SessionRequestMessageTemplate());
        msgpack.register(SessionResponseMessage.class, (Template)new SessionResponseMessageTemplate());
        msgpack.register(ScriptRequestMessage.class, (Template)new ScriptRequestMessageTemplate());
        msgpack.register(ScriptResponseMessage.class, (Template)new MsgPackScriptResponseMessageTemplate());
    }
}

