/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol.serializer.msgpack.templates;

import com.tinkerpop.rexster.protocol.msg.RexProMessageMeta;
import java.io.IOException;
import java.util.Map;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.template.Templates;
import org.msgpack.type.Value;
import org.msgpack.unpacker.Unpacker;

public class MetaTemplate
extends AbstractTemplate<RexProMessageMeta> {
    public static MetaTemplate instance = new MetaTemplate();

    public void write(Packer pk, RexProMessageMeta v) throws IOException {
        this.write(pk, v, false);
    }

    public void write(Packer pk, RexProMessageMeta v, boolean required) throws IOException {
        RexProMessageMeta meta = v;
        if (meta == null) {
            meta = new RexProMessageMeta();
        }
        pk.writeMapBegin(meta.size());
        for (Map.Entry pair : meta.entrySet()) {
            pk.write(pair.getKey());
            pk.write(pair.getValue());
        }
        pk.writeMapEnd();
    }

    public RexProMessageMeta read(Unpacker u, RexProMessageMeta to) throws IOException {
        return this.read(u, to, false);
    }

    protected Object deserializeObject(Value v) {
        if (v == null) {
            return null;
        }
        if (v.isBooleanValue()) {
            return v.asBooleanValue().getBoolean();
        }
        if (v.isFloatValue()) {
            return v.asFloatValue().getDouble();
        }
        if (v.isIntegerValue()) {
            return v.asIntegerValue().getInt();
        }
        return v.asRawValue().getString();
    }

    public RexProMessageMeta read(Unpacker u, RexProMessageMeta to, boolean required) throws IOException {
        RexProMessageMeta meta;
        if (!required && u.trySkipNil()) {
            return null;
        }
        if (to != null) {
            meta = to;
            meta.clear();
        } else {
            meta = new RexProMessageMeta();
        }
        int n = u.readMapBegin();
        for (int i = 0; i < n; ++i) {
            String key = (String)u.read(Templates.TString);
            Object val = this.deserializeObject((Value)u.read(Templates.TValue));
            meta.put(key, val);
        }
        u.readMapEnd();
        return meta;
    }

    public static MetaTemplate getInstance() {
        return instance;
    }
}

