/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol.serializer.msgpack.templates;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.pipes.util.structures.Row;
import com.tinkerpop.pipes.util.structures.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.msgpack.packer.Packer;
import org.msgpack.type.ArrayValue;
import org.msgpack.type.MapValue;
import org.msgpack.type.NilValue;
import org.msgpack.type.Value;
import org.msgpack.type.ValueFactory;

public class ResultsConverter {
    static Object serializeElementId(Element element) {
        Object id = element.getId();
        if (id.getClass().isPrimitive()) {
            return id;
        }
        return id.toString();
    }

    public static void serializeObject(Object object, Packer packer) throws Exception {
        if (object == null) {
            packer.write((Value)ValueFactory.createNilValue());
        } else if (object instanceof String || object instanceof Number || object instanceof Boolean) {
            packer.write(object);
        } else if (object instanceof Element) {
            try {
                Element element = (Element)object;
                Set propertyKeys = element.getPropertyKeys();
                int n = propertyKeys.size();
                boolean isVertex = !(element instanceof Edge);
                int elementSize = (isVertex ? 2 : 5) + (n > 0 ? 1 : 0);
                packer.writeMapBegin(elementSize);
                packer.write("_id");
                packer.write(ResultsConverter.serializeElementId(element));
                if (isVertex) {
                    packer.write("_type");
                    packer.write("vertex");
                } else {
                    Edge edge = (Edge)element;
                    packer.write("_type");
                    packer.write("edge");
                    packer.write("_inV");
                    packer.write(ResultsConverter.serializeElementId((Element)edge.getVertex(Direction.IN)));
                    packer.write("_outV");
                    packer.write(ResultsConverter.serializeElementId((Element)edge.getVertex(Direction.OUT)));
                    packer.write("_label");
                    packer.write(edge.getLabel());
                }
                if (propertyKeys.size() > 0) {
                    packer.write("_properties");
                    packer.writeMapBegin(n);
                    for (String propertyKey : propertyKeys) {
                        packer.write(propertyKey);
                        ResultsConverter.serializeObject(element.getProperty(propertyKey), packer);
                    }
                    packer.writeMapEnd(false);
                }
                packer.writeMapEnd(false);
            }
            catch (Exception e) {
                packer.writeNil();
            }
        } else if (object instanceof Map) {
            Map map = (Map)object;
            packer.writeMapBegin(map.size());
            for (Object k : map.keySet()) {
                if (k instanceof Element) {
                    Element element = (Element)k;
                    ResultsConverter.writeMapKey(element.getId(), packer);
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    m.put("_key", element);
                    m.put("_value", map.get(k));
                    ResultsConverter.serializeObject(m, packer);
                    continue;
                }
                ResultsConverter.writeMapKey(k, packer);
                ResultsConverter.serializeObject(map.get(k), packer);
            }
            packer.writeMapEnd();
        } else if (object instanceof Table) {
            Table table = (Table)object;
            Iterator rows = table.iterator();
            packer.writeArrayBegin(table.size());
            while (rows.hasNext()) {
                ResultsConverter.serializeObject(rows.next(), packer);
            }
            packer.writeArrayEnd();
        } else if (object instanceof Row) {
            Row row = (Row)object;
            List columnNames = row.getColumnNames();
            packer.writeMapBegin(columnNames.size());
            for (String columnName : columnNames) {
                packer.write(columnName);
                ResultsConverter.serializeObject(row.getColumn(columnName), packer);
            }
            packer.writeMapEnd(false);
        } else if (object instanceof Iterable) {
            ArrayList<Object> contents = object instanceof Collection ? (ArrayList<Object>)object : ResultsConverter.iterateToList(((Iterable)object).iterator());
            packer.writeArrayBegin(contents.size());
            for (Object e : contents) {
                ResultsConverter.serializeObject(e, packer);
            }
            packer.writeArrayEnd();
        } else if (object instanceof Iterator) {
            ArrayList<Object> contents = ResultsConverter.iterateToList((Iterator)object);
            packer.writeArrayBegin(contents.size());
            for (Object e : contents) {
                ResultsConverter.serializeObject(e, packer);
            }
            packer.writeArrayEnd();
        } else if (object instanceof NilValue) {
            packer.write((Value)((NilValue)object));
        } else {
            packer.write(object.toString());
        }
    }

    private static void writeMapKey(Object key, Packer packer) throws IOException {
        if (key instanceof String || key instanceof Number) {
            packer.write(key);
        } else {
            packer.write(key.toString());
        }
    }

    private static ArrayList<Object> iterateToList(Iterator itty) {
        ArrayList<Object> contents = new ArrayList<Object>();
        while (itty.hasNext()) {
            contents.add(itty.next());
        }
        return contents;
    }

    public static Object deserializeObject(Value v) {
        Object o;
        if (v == null) {
            o = null;
        } else if (v.isBooleanValue()) {
            o = v.asBooleanValue().getBoolean();
        } else if (v.isFloatValue()) {
            o = v.asFloatValue().getDouble();
        } else if (v.isIntegerValue()) {
            o = v.asIntegerValue().getLong();
        } else if (v.isArrayValue()) {
            ArrayValue src = v.asArrayValue();
            ArrayList<Object> dst = new ArrayList<Object>(src.size());
            for (int i = 0; i < src.size(); ++i) {
                Object val = ResultsConverter.deserializeObject((Value)src.get(i));
                dst.add(i, val);
            }
            o = dst;
        } else if (v.isMapValue()) {
            MapValue src = v.asMapValue();
            HashMap<Object, Object> dst = new HashMap<Object, Object>(src.size());
            for (Map.Entry entry : src.entrySet()) {
                Object key = ResultsConverter.deserializeObject((Value)entry.getKey());
                Object val = ResultsConverter.deserializeObject((Value)entry.getValue());
                dst.put(key, val);
            }
            o = dst;
        } else {
            o = v.isNilValue() ? null : v.asRawValue().getString();
        }
        return o;
    }
}

