/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.protocol.serializer.msgpack.templates.messages;

import com.tinkerpop.rexster.protocol.msg.ScriptRequestMessage;
import com.tinkerpop.rexster.protocol.serializer.msgpack.templates.BindingsTemplate;
import com.tinkerpop.rexster.protocol.serializer.msgpack.templates.messages.RexProMessageTemplate;
import java.io.IOException;
import org.msgpack.packer.Packer;
import org.msgpack.unpacker.Unpacker;

public class ScriptRequestMessageTemplate
extends RexProMessageTemplate<ScriptRequestMessage> {
    @Override
    protected int messageArraySize() {
        return super.messageArraySize() + 3;
    }

    @Override
    protected ScriptRequestMessage instantiateMessage() {
        return new ScriptRequestMessage();
    }

    @Override
    protected void writeMessageArray(Packer pk, ScriptRequestMessage msg) throws IOException {
        super.writeMessageArray(pk, msg);
        pk.write(msg.LanguageName);
        pk.write(msg.Script);
        BindingsTemplate.getInstance().write(pk, msg.Bindings);
    }

    @Override
    protected ScriptRequestMessage readMessageArray(Unpacker un, ScriptRequestMessage msg) throws IOException {
        ScriptRequestMessage message = super.readMessageArray(un, msg);
        message.LanguageName = un.trySkipNil() ? null : un.readString();
        message.Script = un.trySkipNil() ? null : un.readString();
        message.Bindings = BindingsTemplate.getInstance().read(un, null);
        return message;
    }
}

